/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.AbstractSMSkull;
import sweetmagic.init.entity.projectile.FireMagicShot;

public class SkullFlameArcher
extends AbstractSMSkull {
    protected int defTime = 0;

    public SkullFlameArcher(Level world) {
        super(EntityInit.skullFlameArcher, world);
    }

    public SkullFlameArcher(EntityType<? extends AbstractSMSkull> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, 140, 24.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        return super.m_6469_(src, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.defTime > 0) {
            --this.defTime;
        }
        this.tickEffect(ParticleTypes.f_123744_, PotionInit.flame);
    }

    public void m_6504_(LivingEntity target, float par1) {
        int shotRange;
        boolean isWarden = target instanceof Warden;
        boolean isHard = this.isHard(this.m_9236_());
        float damage = isWarden ? 13.0f : 2.0f;
        float shotSpeed = isWarden ? 7.5f : 1.75f;
        int n = shotRange = isWarden ? 50 : 40;
        if (!isWarden && isHard) {
            damage += 1.5f;
        }
        for (int i = 0; i < 5; ++i) {
            FireMagicShot entity = new FireMagicShot(this.m_9236_(), (LivingEntity)this);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20189_() - this.m_20189_();
            double d3 = target.m_20227_(0.3333333333333333) - this.m_20186_();
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(d0, d3, d1), -24 + i * 12);
            entity.m_6686_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), shotSpeed, 1.0f);
            entity.setAddDamage(entity.getAddDamage() + damage);
            entity.setMaxLifeTime(shotRange);
            entity.setArrow(true);
            entity.setRange(3.5);
            this.m_9236_().m_7967_((Entity)entity);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    @Override
    public boolean isLowRank() {
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(world, dif, spawn, data, tag);
        this.initMobData((LivingEntity)this, dif);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
        return data;
    }
}

