/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.AbstractSMSkull;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.util.PlayerHelper;

public class SkullFrostRoyalGuard
extends AbstractSMSkull {
    protected int defTime = 0;
    private int recastTime = 300;
    private static final EntityDataAccessor<Float> HEALTH_ARMOR = ISMMob.setData(SkullFrostRoyalGuard.class, FLOAT);
    private static final EntityDataAccessor<Float> MAX_HEALTH_ARMOR = ISMMob.setData(SkullFrostRoyalGuard.class, FLOAT);

    public SkullFrostRoyalGuard(Level world) {
        super(EntityInit.skullFrostRoyalGuard, world);
    }

    public SkullFrostRoyalGuard(EntityType<? extends AbstractSMSkull> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(HEALTH_ARMOR, Float.valueOf(0.0f));
        this.define(MAX_HEALTH_ARMOR, Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, 40, 24.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public boolean m_6469_(DamageSource src, float amount) {
        float armor;
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        if ((armor = this.getHealthArmor()) > 0.0f) {
            this.setHealthArmor(armor - amount);
            amount = 0.0f;
            if (this.getHealthArmor() > 0.0f) {
                this.m_5496_(SoundEvents.f_11704_, 0.67f, 1.25f);
            } else {
                this.m_5496_(SoundEvents.f_12018_, 2.0f, 1.0f);
            }
        }
        return super.m_6469_(src, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.defTime > 0) {
            --this.defTime;
        }
        this.tickEffect(ParticleInit.FROST, PotionInit.frost);
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null || this.recastTime-- > 0 || this.isLeader((LivingEntity)this)) {
            return;
        }
        this.recastTime = this.m_217043_().m_188503_(150) + 250;
        int buffSize = PlayerHelper.getEffectList(target, PotionInit.BUFF).size();
        this.setHealthArmor(this.m_21233_() * (0.25f + (float)buffSize * 0.05f));
        this.setMaxHealthArmor(this.getHealthArmor());
        this.m_5496_(SoundEvents.f_11887_, 0.5f, 1.175f);
    }

    public void m_6504_(LivingEntity target, float par1) {
        int shotRange;
        if (this.getGuard()) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        boolean isHard = this.isHard(this.m_9236_());
        float damage = isWarden ? 15.0f : 3.0f;
        float shotSpeed = isWarden ? 3.5f : 2.0f;
        float shake = 0.0f;
        int n = shotRange = isWarden ? 40 : 30;
        if (!isWarden && isHard) {
            damage += 1.5f;
        }
        FrostMagicShot entity = new FrostMagicShot(this.m_9236_(), (LivingEntity)this);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entity.m_6686_(d0, d1 - d3 * (double)0.065f, d2, shotSpeed, shake);
        entity.setAddDamage(entity.getAddDamage() + damage);
        entity.setMaxLifeTime(shotRange);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.m_9236_().m_7967_((Entity)entity);
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128350_("health_armor", this.getHealthArmor());
        tags.m_128350_("max_health_armor", this.getMaxHealthArmor());
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setHealthArmor(tags.m_128457_("health_armor"));
        this.setMaxHealthArmor(tags.m_128457_("max_health_armor"));
    }

    public boolean getGuard() {
        return (double)this.getHealthArmor() > 0.0;
    }

    public float getHealthArmor() {
        return ((Float)this.get(HEALTH_ARMOR)).floatValue();
    }

    public void setHealthArmor(float armor) {
        this.set(HEALTH_ARMOR, Float.valueOf(armor));
    }

    public float getMaxHealthArmor() {
        return ((Float)this.get(MAX_HEALTH_ARMOR)).floatValue();
    }

    public void setMaxHealthArmor(float armor) {
        this.set(MAX_HEALTH_ARMOR, Float.valueOf(armor));
    }

    @Override
    public boolean isLowRank() {
        return false;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
        return super.finalizeSpawn(info);
    }
}

