/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.entity.projectile.LightningRod;
import sweetmagic.init.entity.projectile.TridentThunder;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public class BlitzWizardMaster
extends AbstractSMBoss {
    private int thunderCount = 0;
    private int thunderTime = 0;
    private static final int MAX_THUNDERTIME = 240;
    private int lightningRodTime = 250;
    private static final int MAX_LIGHTNINGRODTIME = 640;
    private int lightningWebTime = 0;
    private static final int MAX_LIGHTNINGWEBTIME = 600;
    private int tridentReleaseTime = 300;
    private static final int MAX_TRIDENTRELEASETIME = 450;
    public List<BlockPos> posList = new ArrayList<BlockPos>();
    public List<TridentThunder> tridentList = new ArrayList<TridentThunder>();
    private static final EntityDataAccessor<Boolean> UP_BOOK = ISMMob.setData(BlitzWizardMaster.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> LIGHNING_WEB = ISMMob.setData(BlitzWizardMaster.class, BOOLEAN);

    public BlitzWizardMaster(Level world) {
        super(EntityInit.blitzWizardMaster, world);
    }

    public BlitzWizardMaster(EntityType<BlitzWizardMaster> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 600;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 768.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(LIGHNING_WEB, false);
        this.define(UP_BOOK, false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    public boolean getLighningWeb() {
        return (Boolean)this.get(LIGHNING_WEB);
    }

    public void setLighningWeb(boolean lighningWeb) {
        this.set(LIGHNING_WEB, lighningWeb);
    }

    public boolean getUpBook() {
        return (Boolean)this.get(UP_BOOK);
    }

    public void setUpBook(boolean upBook) {
        this.set(UP_BOOK, upBook);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("lighningWeb", this.getLighningWeb());
        tags.m_128379_("upBook", this.getUpBook());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setLighningWeb(tags.m_128471_("lighningWeb"));
        this.setUpBook(tags.m_128471_("upBook"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        float cap = this.isHalfHealth((LivingEntity)this) ? 4.0f : 6.0f;
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, cap);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.clearInfo();
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
        }
    }

    @Override
    protected void armorHealthSet(LivingEntity target, int count) {
        this.setMaxHealthArmor((100.0f + this.getPlayerCount(target) * 12.5f) * (float)count);
        this.setHealthArmor(this.getMaxHealthArmor());
    }

    public void firstAttack(LivingEntity target) {
        if (this.thunderTime++ >= 240) {
            this.rangeThunder(target);
        }
        if (this.lightningRodTime++ >= 640) {
            this.lightningRod(target);
            this.lightningRodTime = 0;
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.lightningWebTime++ + 300 >= 600) {
            this.lightningWeb(target);
        }
        if (this.tridentReleaseTime++ + 200 >= 450) {
            this.tridentRelease(target);
        }
    }

    public void rangeThunder(LivingEntity target) {
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        float damage = isWarden ? 50.0f : 7.5f;
        int angle = 15 - this.thunderCount;
        int rangeMax = this.isHalfHealth((LivingEntity)this) ? 16 : 8;
        double x = target.m_20185_() - this.m_20185_();
        double z = target.m_20189_() - this.m_20189_();
        double y = 0.0;
        Vec3 base = new Vec3(x, y, z);
        for (int i = 0; i < rangeMax; ++i) {
            ElectricMagicShot entity = new ElectricMagicShot(this.m_9236_(), (LivingEntity)this);
            Vector3f vec = this.getShotVector((Mob)this, base, 360 / rangeMax * (i + 1) + angle);
            entity.m_6686_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), 0.875f, 2.0f);
            entity.setAddDamage(entity.getAddDamage() + damage);
            entity.setMaxLifeTime(40);
            entity.setRange(3.5);
            entity.setHitDead(false);
            entity.setNotDamage(true);
            entity.isRangeAttack = true;
            this.addEntity((Entity)entity);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        if (this.thunderCount++ >= 3) {
            this.thunderTime = 0;
            this.thunderCount = 0;
        }
    }

    public void lightningRod(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() + (double)this.getRandFloat(4.0f);
            double z = entity.m_20189_() + (double)this.getRandFloat(4.0f);
            LightningRod magic = new LightningRod(this.m_9236_(), (LivingEntity)this);
            magic.setHitDead(false);
            magic.setNotDamage(true);
            magic.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
            magic.m_6034_(x, this.f_19855_, z);
            magic.setAddDamage(magic.getAddDamage() + 30.0f);
            magic.setRange(4.0);
            magic.setMaxLifeTime(400 + this.rand.nextInt(60));
            this.addEntity((Entity)magic);
        }
    }

    public void lightningWeb(LivingEntity target) {
        this.setLighningWeb(true);
        for (int i = 0; i < 4; ++i) {
            float damage = 8.0f;
            float angle = (float)i * 1.5f;
            float addX = (float)Math.sin(angle + (float)this.f_19797_ / 20.0f) * ((float)Math.cos((float)this.f_19797_ / 20.0f) * 12.5f + 15.0f);
            float addZ = -((float)Math.cos(angle + (float)this.f_19797_ / 20.0f)) * ((float)Math.cos((float)this.f_19797_ / 20.0f) * 12.5f + 15.0f);
            BlockPos pos = WorldHelper.offset(this.m_20183_(), addX, 0.0, addZ);
            List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, (T e) -> !(e instanceof ISMMob), pos, 2.0);
            for (LivingEntity entity : targetList) {
                boolean hasEffect = entity.m_21023_(PotionInit.lightning_wind_vulnerable);
                float newDamage = hasEffect ? damage * 1.5f : damage;
                this.attackDamage((Entity)entity, (DamageSource)SMDamage.magicDamage, newDamage);
            }
        }
        if (this.lightningWebTime - 200 >= 600) {
            this.lightningWebTime = 0;
            this.setLighningWeb(false);
            this.setUpBook(false);
        }
    }

    public void tridentRelease(LivingEntity target) {
        if (this.tridentReleaseTime >= 450 && this.tridentList.isEmpty()) {
            this.tridentReleaseTime = 0;
        } else if (this.tridentList.isEmpty()) {
            Vec3 look = this.m_20252_(-1.0f);
            Vec3 src = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)this.m_20192_(), 0.0);
            Vec3 dest = src.m_82520_(look.f_82479_ * 3.0, this.m_20186_(), look.f_82481_ * 3.0);
            List<LivingEntity> targetList = this.getPlayerList(target);
            if (targetList.isEmpty()) {
                return;
            }
            int count = (int)Math.min(50.0f, this.getPlayerCount(targetList) * 3.0f);
            for (int i = 0; i < count; ++i) {
                BlockPos pos;
                while (this.posList.contains(pos = new BlockPos((int)dest.f_82479_ + this.randRange(20), (int)this.m_20186_() + 4 + this.rand.nextInt(10), (int)dest.f_82481_ + this.randRange(20)))) {
                }
                LivingEntity entity = targetList.get(this.rand.nextInt(targetList.size()));
                double x = entity.m_20185_() - (double)pos.m_123341_();
                double y = entity.m_20227_(0.3333333333333333) - (double)pos.m_123342_() + 1.25;
                double z = entity.m_20189_() - (double)pos.m_123343_();
                double xz = Math.sqrt(x * x + z * z);
                TridentThunder knife = new TridentThunder(this.m_9236_(), (LivingEntity)this);
                knife.setHitDead(false);
                knife.m_6686_(x, y - xz * 0.065, z, 3.0f, 2.0f);
                knife.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                knife.setAddDamage(knife.getAddDamage() + 20.0f);
                knife.setRange(3.0);
                knife.setCharge(true);
                this.addEntity((Entity)knife);
                this.tridentList.add(knife);
                this.posList.add(pos);
            }
        }
        if (this.tridentReleaseTime + 100 >= 450 && !this.tridentList.isEmpty() && this.f_19797_ % 2 == 0) {
            List<LivingEntity> targetList = this.getPlayerList(target);
            if (targetList.isEmpty()) {
                return;
            }
            int size = Math.min(targetList.size(), this.rand.nextInt(targetList.size()));
            LivingEntity entity = targetList.get(size);
            TridentThunder knife = this.tridentList.get(0);
            double x = entity.m_20185_() - knife.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - knife.m_20186_() + 1.25;
            double z = entity.m_20189_() - knife.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            knife.m_6686_(x, y - xz * 0.065, z, 3.0f, 2.0f);
            knife.setCharge(false);
            this.tridentList.remove(0);
            this.posList.remove(0);
            if (this.tridentList.isEmpty()) {
                this.tridentReleaseTime = 0;
            }
        }
    }

    @Override
    public void spawnAction() {
        this.setHealthArmorCount(this.getHealthArmorCount() + 1);
    }

    @Override
    public void clearInfo() {
        this.lightningRodTime = 0;
        this.thunderCount = 0;
        this.thunderTime = 0;
        if (this.tridentReleaseTime > 0) {
            List<TridentThunder> targetList = this.getEntityList(TridentThunder.class, 48.0);
            targetList.forEach(e -> e.m_146870_());
            this.tridentReleaseTime = 0;
        }
        if (this.lightningWebTime == 0) {
            this.lightningWebTime = 0;
            this.setLighningWeb(false);
            this.setUpBook(false);
        }
    }

    public void m_6667_(DamageSource src) {
        super.m_6667_(src);
        List<TridentThunder> targetList = this.getEntityList(TridentThunder.class, 64.0);
        targetList.forEach(e -> e.m_146870_());
    }
}

