/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.BraveShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.util.SMDamage;

public class BraveSkeleton
extends AbstractSMBoss {
    private int firstTick = 25;
    private static final int MAX_FIRST_TICK = 150;
    private int secondTick = 400;
    private static final int MAX_SECOND_TICK = 600;
    private int firstCount = 0;
    private int arrowTick = 0;
    private static final int MAX_ARROW_TICK = 600;
    public boolean isNotGround = false;
    private static final EntityDataAccessor<Boolean> ARROW = ISMMob.setData(BraveSkeleton.class, BOOLEAN);

    public BraveSkeleton(Level world) {
        super(EntityInit.braveSkeleton, world);
    }

    public BraveSkeleton(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.f_19793_ = 1.25f;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ARROW, false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 512.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 16.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    public boolean getArrow() {
        return (Boolean)this.get(ARROW);
    }

    public void setArrow(boolean arrow) {
        this.set(ARROW, arrow);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("Arrow", this.getArrow());
        tags.m_128405_("firstTick", this.firstTick);
        tags.m_128405_("secondTick", this.secondTick);
        tags.m_128405_("firstCount", this.firstCount);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setArrow(tags.m_128471_("Arrow"));
        this.firstTick = tags.m_128451_("firstTick");
        this.secondTick = tags.m_128451_("secondTick");
        this.firstCount = tags.m_128451_("firstCount");
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 7.0f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (this.isRiding()) {
            SkeletonHorse horse = (SkeletonHorse)this.m_20202_();
            horse.m_21153_(horse.m_21223_() - amount);
            amount = Math.min(0.0f, amount);
        }
        return super.m_6469_(src, amount);
    }

    @Override
    public void initBossBar() {
        ServerBossEvent event = this.getBossEvent();
        if (event == null) {
            return;
        }
        if (this.isRiding()) {
            Entity entity = this.m_20202_();
            if (entity instanceof SkeletonHorse) {
                SkeletonHorse horse = (SkeletonHorse)entity;
                event.m_142711_(horse.m_21223_() / horse.m_21233_());
                event.m_6451_(BossEvent.BossBarColor.GREEN);
            }
        } else {
            if (!this.isHalfHealth((LivingEntity)this)) {
                event.m_6451_(BossEvent.BossBarColor.BLUE);
            }
            super.initBossBar();
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.checkSpawnPos();
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
            this.checkPotion(PotionInit.reflash_effect, 9999, 0);
        }
        if (this.arrowTick++ >= 600) {
            this.setArrow(!this.getArrow());
            this.arrowTick = 0;
        }
        if (this.isRiding() && !this.m_21023_(MobEffects.f_19600_)) {
            this.addPotion((LivingEntity)this, MobEffects.f_19600_, 9999, 2);
        }
    }

    public void firstAttack(LivingEntity target) {
        if (this.firstTick++ < 150) {
            return;
        }
        if (this.getArrow()) {
            this.arrowAttak(target);
        } else {
            this.swordAttak(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.secondTick++ >= 600) {
            this.blazeAttak(target);
        } else if (this.secondTick >= 400 && this.f_19797_ % 10 == 0) {
            this.blazeParticle(target);
        }
    }

    public void arrowAttak(LivingEntity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        List<LivingEntity> targetList = this.getPlayerList(target);
        int size = Math.min(40, targetList.size() * 4);
        for (int i = 0; i < size; ++i) {
            FireMagicShot magic = new FireMagicShot(this.m_9236_(), (LivingEntity)this);
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20227_(0.3333333333333333) - this.m_20186_() - 1.0;
            double z = target.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            magic.m_6686_(x, y - xz * 0.0, z, 2.0f, 40.0f);
            magic.setAddDamage(magic.getAddDamage() + damage);
            magic.setMaxLifeTime(100 + this.rand.nextInt(30));
            magic.setArrow(true);
            magic.setRange(2.0);
            this.addEntity((Entity)magic);
        }
        this.m_5496_(SoundEvents.f_11687_, 0.5f, 0.875f);
        this.firstTick = (int)Math.max(0.0f, 100.0f - this.getPlayerCount(targetList) * 10.0f);
    }

    public void swordAttak(LivingEntity target) {
        if (this.firstTick == 151) {
            this.m_20256_(new Vec3(0.0, 2.5, 0.0));
        } else if (this.firstTick >= 152) {
            if (!this.m_20096_()) {
                this.isNotGround = true;
            } else if (this.m_20096_() && this.isNotGround) {
                double d1 = target.m_20185_() - this.m_20185_();
                double d2 = target.m_20189_() - this.m_20189_();
                this.m_146922_(-((float)Math.atan2(d1, d2)) * 57.295776f);
                this.isNotGround = false;
                this.firstTick = 0;
                float amount = 30.0f + this.getBuffPower();
                List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), 16.0);
                entityList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), amount));
                this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                Vec3 src = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)this.m_20192_(), 0.0);
                Vec3 look = this.m_20252_(10.0f);
                BlockState state = BlockInit.aether_flame.m_49966_();
                for (int i = 0; i < 16; ++i) {
                    Vec3 dest = src.m_82520_(look.f_82479_ * (double)i, this.m_20186_(), look.f_82481_ * (double)i);
                    BlockPos pos = new BlockPos((int)dest.f_82479_, (int)this.m_20186_(), (int)dest.f_82481_);
                    if (!this.m_9236_().m_46859_(pos)) continue;
                    this.m_9236_().m_7731_(pos, state, 3);
                }
                float damage = (float)this.m_21133_(Attributes.f_22281_) * 1.5f;
                BraveShot magic = new BraveShot(this.m_9236_(), (LivingEntity)this);
                double x = target.m_20185_() - this.m_20185_();
                double y = target.m_20227_(0.3333333333333333) - this.m_20186_() - 1.5;
                double z = target.m_20189_() - this.m_20189_();
                double xz = Math.sqrt(x * x + z * z);
                magic.m_6686_(x, y - xz * 0.0, z, 1.875f, 0.0f);
                magic.setAddDamage(magic.getAddDamage() + damage);
                magic.setMaxLifeTime(100 + this.rand.nextInt(30));
                magic.setRange(7.0);
                this.addEntity((Entity)magic);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
    }

    public void blazeAttak(LivingEntity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_) * 2.0f;
        double range = 12.0 + Math.min(15.0, (double)this.getPlayerCount(target) * 2.0);
        BlockPos pos = this.m_20183_();
        List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), range);
        for (LivingEntity entity : targetList) {
            if (!this.checkDistances(pos, entity.m_20183_(), range * range)) continue;
            boolean hasEffect = entity.m_21023_(PotionInit.reflash_effect);
            damage = hasEffect ? damage * 1.5f : damage;
            entity.m_6469_((DamageSource)SMDamage.magicDamage, damage);
        }
        this.secondTick = 0;
    }

    public void blazeParticle(LivingEntity target) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double range = 10.0 + Math.min(15.0, (double)this.getPlayerCount(target) * 2.0);
        BlockPos pos = this.m_20183_();
        Iterable posList = this.getPosList(pos, range);
        for (BlockPos p : posList) {
            if (this.rand.nextFloat() >= 0.067f || !this.checkDistances(pos, p, range * range)) continue;
            double x = (double)p.m_123341_() + this.rand.nextDouble() * 1.5 - 0.75;
            double y = (double)p.m_123342_() + this.rand.nextDouble() * 1.5 - 0.75;
            double z = (double)p.m_123343_() + this.rand.nextDouble() * 1.5 - 0.75;
            double xSpeed = this.getRandFloat(0.1f);
            double ySpeed = this.getRandFloat(0.05f);
            double zSpeed = this.getRandFloat(0.1f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0, xSpeed, ySpeed + (double)0.2f, zSpeed, 1.0);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 1.0f);
    }

    @Override
    protected void teleportSpawnPos(BlockPos pos) {
        if (this.isRiding()) {
            if (this.m_9236_().m_46859_(pos)) {
                double x = (double)pos.m_123341_() + (this.rand.nextDouble() - 0.5) * 10.0;
                double y = pos.m_123342_();
                double z = (double)pos.m_123343_() + (this.rand.nextDouble() - 0.5) * 10.0;
                this.m_20202_().m_6034_(x, y, z);
            }
        } else {
            super.teleportSpawnPos(pos);
        }
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.spawnHorse((LevelAccessor)info.world(), this.m_20183_().m_7494_());
        return super.finalizeSpawn(info);
    }

    public SkeletonHorse spawnHorse(LevelAccessor world, BlockPos pos) {
        SkeletonHorse horse = (SkeletonHorse)EntityType.f_20525_.m_20615_(this.m_9236_());
        horse.m_30586_(this.m_20148_());
        horse.m_30649_(100);
        horse.m_30651_(true);
        horse.m_21051_(Attributes.f_22276_).m_22100_((double)this.m_21233_() * 0.25);
        horse.m_21051_(Attributes.f_22284_).m_22100_(10.0);
        horse.m_21051_(Attributes.f_22279_).m_22100_(0.4);
        horse.m_21051_(Attributes.f_22288_).m_22100_(10.0);
        horse.m_21153_(horse.m_21233_());
        horse.m_146762_(0);
        this.addEntity((Entity)horse);
        horse.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        this.m_20329_((Entity)horse);
        this.addPotion((LivingEntity)horse, PotionInit.aether_barrier, 1200, 4);
        return horse;
    }

    public boolean isRiding() {
        Entity entity = this.m_20202_();
        return entity != null && entity.m_6084_();
    }

    @Override
    public void clearInfo() {
    }

    public double m_6049_() {
        return -0.7;
    }
}

