/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.IAngel;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.util.SMDamage;

public class HolyAngel
extends AbstractSMBoss
implements IAngel {
    private int holyLightTime = 0;
    private int oruChargeTime = 0;
    private int holyLightMaxTime = 500;
    private static final int ORUCHARGE_MAXTIME = 300;
    private Map<Integer, BlockPos> posMap = new LinkedHashMap<Integer, BlockPos>();
    private List<Player> playerList = new ArrayList<Player>();
    private static final EntityDataAccessor<Integer> ORU = ISMMob.setData(HolyAngel.class, INT);
    private static final EntityDataAccessor<Boolean> CHARGE = ISMMob.setData(HolyAngel.class, BOOLEAN);

    public HolyAngel(Level world) {
        super(EntityInit.holyAngel, world);
    }

    public HolyAngel(EntityType<HolyAngel> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 400;
        this.f_19793_ = 1.25f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ORU, 0);
        this.define(CHARGE, false);
    }

    protected SoundEvent m_7515_() {
        return SoundInit.PAGE;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundInit.PAGE;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.PAGE;
    }

    public float m_6121_() {
        return 0.25f;
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        boolean isLectern = this.getLectern();
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, isLectern ? 10.0f : 5.75f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (isLectern) {
            amount = this.getLecternAction(src, amount, this.getORU());
        }
        return super.m_6469_(src, amount);
    }

    public float getLecternAction(DamageSource src, float amount, int armorSize) {
        if (armorSize > 0) {
            if (src.m_7640_() instanceof EvilArrow) {
                amount = this.getEvilDamage(amount, armorSize);
            } else {
                amount *= 0.1f;
                this.specialDamageCut(src, this.playerList, "queen_damecut");
            }
        } else {
            amount = Math.min(5.0f, amount);
            this.halfHealthTeleport();
        }
        return amount;
    }

    public float getEvilDamage(float amount, int armorSize) {
        this.setORU(armorSize - 1);
        amount = 10.0f / (float)this.getEntityList(Player.class, 80.0).size();
        this.m_5496_(SoundEvents.f_11983_, 3.0f, 1.1f);
        if (this.getORU() <= 0) {
            amount = this.m_21233_() * 0.2f;
            this.m_5496_(SoundEvents.f_12089_, 1.0f, 1.0f);
            BlockPos pos = this.m_20183_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)level;
                for (int i = 0; i < 16; ++i) {
                    float x = (float)pos.m_123341_() + this.rand.nextFloat();
                    float y = (float)pos.m_123342_() + this.rand.nextFloat() + 0.5f;
                    float z = (float)pos.m_123343_() + this.rand.nextFloat();
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123756_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
                }
            }
        }
        return amount;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("oru", this.getORU());
        tags.m_128379_("isCharge", this.getCharge());
        tags.m_128405_("oruChargeTime", this.oruChargeTime);
        tags.m_128405_("holyLightTime", this.holyLightTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setORU(tags.m_128451_("oru"));
        this.setCharge(tags.m_128471_("isCharge"));
        this.oruChargeTime = tags.m_128451_("oruChargeTime");
        this.holyLightTime = tags.m_128451_("holyLightTime");
        if (!this.getLectern()) {
            this.setBossEvent(BC_BLUE, NOTCHED_6);
        }
    }

    public int getORU() {
        return (Integer)this.get(ORU);
    }

    public void setORU(int size) {
        this.set(ORU, Math.min(24, size));
    }

    @Override
    public boolean getCharge() {
        return (Boolean)this.get(CHARGE);
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    @Override
    public boolean isArmorEmpty() {
        return this.getORU() <= 0;
    }

    @Override
    public void m_8119_() {
        double distance;
        super.m_8119_();
        if (this.isClient()) {
            Vec3 vec = this.m_20184_();
            float x = (float)this.m_20185_() - 0.5f + this.rand.nextFloat();
            float y = (float)this.m_20186_() + 1.0f;
            float z = (float)this.m_20189_() - 0.5f + this.rand.nextFloat();
            float xS = (float)((vec.f_82479_ + 0.5 - (double)this.rand.nextFloat()) * (double)0.2f);
            float yS = 0.0f;
            float zS = (float)((vec.f_82481_ + 0.5 - (double)this.rand.nextFloat()) * (double)0.2f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y, (double)z, (double)xS, (double)yS, (double)zS);
        }
        BlockPos spawnPos = this.getSpawnPos();
        if (this.f_19797_ % 20 == 0 && spawnPos != null && (distance = this.m_20275_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_())) >= 2000.0) {
            this.teleport();
        }
    }

    @Override
    protected boolean teleport() {
        BlockPos pos = this.getSpawnPos();
        if (!this.isClient() && this.m_6084_() && pos != null) {
            double x = (double)pos.m_123341_() + (this.rand.nextDouble() - 0.5) * 12.0;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + (this.rand.nextDouble() - 0.5) * 12.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (this.getLectern() && this.getORU() <= 0) {
            ++this.oruChargeTime;
            this.posMap.clear();
            if (this.oruChargeTime >= 300) {
                this.clearInfo();
            }
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (!this.isHalfHealth((LivingEntity)this)) {
            this.firstPhaseSttack(target);
        } else {
            this.secondPhaseSttack(target);
        }
    }

    public void firstPhaseSttack(LivingEntity target) {
        double range;
        ++this.holyLightTime;
        double d = range = this.getLectern() ? 16.0 : 24.0;
        if (this.holyLightTime >= this.holyLightMaxTime - 120) {
            if (this.holyLightTime % 30 == 0) {
                BlockPos pos = this.m_20183_();
                this.spawnParticleCycle(pos, range + 1.15);
                this.spawnParticleCycle(pos, range - 3.85);
                this.spawnParticleCycle(pos, range - 7.85);
            }
            this.setCharge(true);
        }
        if (this.holyLightTime < this.holyLightMaxTime) {
            return;
        }
        boolean isPlayer = this.isPlayer((Entity)target);
        BlockPos pos = this.m_20183_();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, pos, range * range), range);
        float damage = (this.getHard() ? 10.0f : 6.0f) + (float)this.getORU() * 2.0f + this.getBuffPower();
        this.attackDamage(entityList, this.getSRC(), damage);
        this.setCharge(false);
        this.holyLightTime = 0;
        this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        Iterable posList = this.getPosList(pos, range);
        for (BlockPos p : posList) {
            if (this.rand.nextFloat() >= 0.2f || !this.checkDistances(pos, p, range * range)) continue;
            float x = (float)p.m_123341_() + this.rand.nextFloat() - 0.5f;
            float y = (float)p.m_123342_() + this.rand.nextFloat() - 0.5f;
            float z = (float)p.m_123343_() + this.rand.nextFloat() - 0.5f;
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y, (double)z, 0, 0.0, (double)(this.rand.nextFloat() * 0.5f), 0.0, 1.0);
        }
    }

    public void secondPhaseSttack(LivingEntity target) {
        ++this.holyLightTime;
        double range = this.getLectern() ? 12.0 : 18.0;
        boolean isPlayer = this.isPlayer((Entity)target);
        if (this.posMap.isEmpty()) {
            this.setPosMap(isPlayer, range);
        }
        if (this.holyLightTime >= this.holyLightMaxTime - 120 && this.holyLightTime % 30 == 0) {
            this.posMap.values().forEach(p -> this.spawnParticleCycle((BlockPos)p, range));
            this.setCharge(true);
        }
        if (this.holyLightTime >= this.holyLightMaxTime && this.f_19797_ % 6 == 0) {
            this.holyLightAttack(isPlayer, range);
        }
    }

    public void setPosMap(boolean isPlayer, double range) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), range);
        if (entityList.isEmpty()) {
            return;
        }
        int mapRange = 20 + (entityList.size() - 1) * 4;
        int size = this.getORU() * 3;
        BlockPos basePos = this.m_20183_();
        for (int i = 0; i < size; ++i) {
            BlockPos pos;
            while (this.posMap.containsValue(pos = new BlockPos(basePos.m_123341_() + this.randRange(mapRange), basePos.m_123342_(), basePos.m_123343_() + this.randRange(mapRange)))) {
            }
            this.posMap.put(i, pos);
        }
    }

    public void holyLightAttack(boolean isPlayer, double range) {
        float damage = (this.getHard() ? 20.0f : 12.0f) + this.getBuffPower();
        Iterator<Map.Entry<Integer, BlockPos>> iterator = this.posMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Level level;
            Map.Entry<Integer, BlockPos> map = iterator.next();
            BlockPos pos = map.getValue();
            AABB aabb = this.getAABB(pos, range);
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, pos, range * range), aabb);
            this.attackDamage(entityList, (DamageSource)SMDamage.magicDamage, damage);
            this.posMap.remove(map.getKey());
            if (this.posMap.isEmpty()) {
                this.holyLightTime = 0;
                this.posMap.clear();
                this.setCharge(false);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)level;
                Iterable posList = this.getPosList(pos, range);
                for (BlockPos p : posList) {
                    if (this.rand.nextFloat() >= 0.15f || !this.checkDistances(pos, p, range * range)) continue;
                    float x = (float)p.m_123341_() + this.rand.nextFloat() - 0.5f;
                    float y = (float)p.m_123342_() + this.rand.nextFloat() - 0.5f;
                    float z = (float)p.m_123343_() + this.rand.nextFloat() - 0.5f;
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y, (double)z, 0, 0.0, (double)(this.rand.nextFloat() * 0.75f), 0.0, 1.0);
                }
            }
            this.m_9236_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11913_, this.m_5720_(), 2.0f, 1.0f);
            return;
        }
        if (this.posMap.isEmpty()) {
            this.holyLightTime = 0;
            this.posMap.clear();
            this.setCharge(false);
        }
    }

    public void setORU() {
        int rate = this.getHard() ? 6 : 4;
        List<Player> playerList = this.getEntityList(Player.class, 80.0);
        if (playerList.isEmpty()) {
            return;
        }
        this.setORU(rate * playerList.size());
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.startInfo();
        return super.finalizeSpawn(info);
    }

    @Override
    public void startInfo() {
        super.startInfo();
        this.setHealthArmorCount(this.getHealthArmorCount() + 1);
        this.setORU(this.getMaxHealthArmorCount());
        this.holyLightMaxTime = 250;
    }

    @Override
    public void clearInfo() {
        this.setORU();
        this.holyLightTime = 0;
        this.oruChargeTime = 0;
        this.setCharge(false);
    }

    @Override
    public float getBuffPower() {
        int armorCount;
        float damage = super.getBuffPower();
        if (!this.getLectern()) {
            damage += 10.0f;
            damage *= 1.5f;
        }
        if ((armorCount = this.getMaxHealthArmorCount()) > 0) {
            damage *= 1.0f + (float)armorCount;
        }
        return damage;
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, BlockPos pos, double range) {
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob) && this.checkDistances(pos, e.m_20183_(), range * range);
    }
}

