/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.ientity.IWolf;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.monster.PhantomWolf;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.PoisonMagicShot;
import sweetmagic.init.entity.projectile.ToxicCircle;
import sweetmagic.util.SMDamage;

public class SilverLandRoad
extends AbstractSMBoss
implements IWolf {
    private UUID ownerID;
    private LivingEntity owner;
    private int toxicTick = 0;
    private static final int MAX_TOXIC_TICK = 400;
    private int poisonTick = 0;
    private static final int MAX_POISON_TICK = 150;
    private int summonTick = 0;
    private static final int MAX_SUMMON_TICK = 600;
    private static final EntityDataAccessor<Boolean> ALIVE = ISMMob.setData(SilverLandRoad.class, BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = ISMMob.setData(SilverLandRoad.class, ISMMob.INT);

    public SilverLandRoad(Level world) {
        super(EntityInit.silverLandRoad, world);
    }

    public SilverLandRoad(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 400;
        this.f_19793_ = 1.25f;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ALIVE, false);
        this.define(ATTACK_TICK, 0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    public float m_6100_() {
        return 0.65f;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public boolean getAlive() {
        return (Boolean)this.get(ALIVE);
    }

    public void setAlive(boolean isAlive) {
        this.set(ALIVE, isAlive);
    }

    public void setAttackTick(int attackTick) {
        this.set(ATTACK_TICK, attackTick);
    }

    @Override
    public int getAttackTick() {
        return (Integer)this.get(ATTACK_TICK);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isAlive", this.m_6084_());
        tags.m_128379_("isHalfHealth", this.getHalfHealthFlag());
        if (this.getOwnerID() != null) {
            tags.m_128362_("ownerID", this.getOwnerID());
        }
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.m_20282_(tags.m_128471_("isAlive"));
        this.setHalfHealth(tags.m_128471_("isHalfHealth"));
        if (tags.m_128441_("ownerID")) {
            this.setOwnerID(tags.m_128342_("ownerID"));
        }
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    @Override
    public void setOwnerID(LivingEntity entity) {
        this.ownerID = entity.m_20148_();
    }

    public void setOwnerID(UUID id) {
        this.ownerID = id;
    }

    public LivingEntity getEntity() {
        Level level;
        LivingEntity entity = this.owner;
        if (entity == null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            entity = (LivingEntity)server.m_8791_(this.getOwnerID());
        }
        return entity;
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 8.0f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (amount > 1.0f) {
            ++this.toxicTick;
            ++this.poisonTick;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    protected void m_8024_() {
        int attackTick;
        LivingEntity target;
        super.m_8024_();
        if (this.isHalfHealth((LivingEntity)this) && !this.getHalfHealthFlag()) {
            this.setHalfHealth(true);
        }
        if ((target = this.m_5448_()) == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this) || this.getHalfHealthFlag()) {
            this.secondAttack(target);
        }
        if (!this.m_6084_()) {
            ++this.toxicTick;
            ++this.poisonTick;
            ++this.summonTick;
        }
        if (this.m_21023_(PotionInit.recast_reduction)) {
            ++this.toxicTick;
            ++this.poisonTick;
            ++this.summonTick;
        }
        if (this.f_19797_ > (attackTick = this.getAttackTick()) + 10) {
            this.setAttackTick(0);
        }
    }

    public void firstAttack(LivingEntity target) {
        if (this.poisonTick++ >= 150) {
            this.poisonAttack(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.summonTick++ >= 600) {
            this.poisonWolf(target);
        }
        if (this.toxicTick++ >= 400) {
            this.toxicCircle(target);
        }
        if (this.f_19797_ % 10 == 0 && this.getOwnerID() != null && this.getAlive()) {
            LivingEntity entity = this.getEntity();
            if (entity != null && entity.m_6084_()) {
                return;
            }
            this.setAlive(false);
            this.m_5634_(this.m_21233_() * 0.5f);
            this.addPotion((LivingEntity)this, MobEffects.f_19600_, 9999, 2);
        }
    }

    public void poisonAttack(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            PoisonMagicShot magic = new PoisonMagicShot(this.m_9236_(), (LivingEntity)this);
            magic.m_6686_(x, y - xz * 0.035, z, 1.0f, 0.0f);
            magic.setAddDamage(magic.getAddDamage() + 10.0f);
            magic.setMaxLifeTime(100);
            this.addEntity((Entity)entity);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.poisonTick = 0;
    }

    public void poisonWolf(LivingEntity target) {
        int size = 1 + (int)this.getPlayerCount(target) / 2;
        for (int i = 0; i < size; ++i) {
            PhantomWolf entity = new PhantomWolf(this.m_9236_());
            entity.m_6034_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5);
            entity.m_21051_(Attributes.f_22276_).m_22100_((double)(this.m_21233_() / 5.0f));
            entity.m_21153_(entity.m_21233_());
            this.addEntity((Entity)entity);
            entity.m_21373_();
            entity.m_20084_(this.m_20148_());
        }
        this.m_5496_(SoundInit.HORAMAGIC, 0.5f, 1.0f);
        this.summonTick = 0;
    }

    public void toxicCircle(LivingEntity target) {
        double range = 5.0 + (double)((int)this.getPlayerCount(target)) * 0.5;
        double x = target.m_20185_() - this.m_20185_();
        double z = target.m_20189_() - this.m_20189_();
        ToxicCircle entity = new ToxicCircle(this.m_9236_(), (LivingEntity)this);
        entity.setHitDead(false);
        entity.m_6686_(x, 0.0, z, 1.0f, 0.0f);
        entity.setAddDamage(entity.getAddDamage() + 6.0f);
        entity.setRange(range);
        entity.setMaxLifeTime(400);
        this.addEntity((Entity)entity);
        this.toxicTick = 0;
        this.setAttackTick(this.f_19797_);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    @Override
    public void startInfo() {
        super.startInfo();
        this.poisonTick = 120;
        this.toxicTick = 240;
        this.summonTick = 500;
    }

    @Override
    public void clearInfo() {
    }
}

