/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.monster.ArchSpider;
import sweetmagic.init.entity.monster.BlazeTempest;
import sweetmagic.init.entity.monster.BlazeTempestTornado;
import sweetmagic.init.entity.monster.CreeperCalamity;
import sweetmagic.init.entity.monster.DwarfZombie;
import sweetmagic.init.entity.monster.DwarfZombieMaster;
import sweetmagic.init.entity.monster.EnderMage;
import sweetmagic.init.entity.monster.EnderShadow;
import sweetmagic.init.entity.monster.SkullFlame;
import sweetmagic.init.entity.monster.SkullFlameArcher;
import sweetmagic.init.entity.monster.SkullFrost;
import sweetmagic.init.entity.monster.SkullFrostRoyalGuard;
import sweetmagic.init.entity.monster.WindWitch;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.TwiLightShot;
import sweetmagic.util.SMDamage;

public class TwilightHora
extends AbstractSMBoss {
    private int summonTime = 500;
    private static final int MAX_SUMMON_TIME = 600;
    private int twilightTime = 0;
    private static final int MAX_TWILIGHT_TIME = 250;
    private int glowTime = 0;
    private List<Player> playerList = new ArrayList<Player>();
    private static final EntityDataAccessor<Boolean> SUMMON = ISMMob.setData(TwilightHora.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> ARMOR = ISMMob.setData(TwilightHora.class, BOOLEAN);

    public TwilightHora(Level world) {
        super(EntityInit.twilightHora, world);
    }

    public TwilightHora(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON, false);
        this.define(ARMOR, false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 512.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    public boolean getSummon() {
        return (Boolean)this.get(SUMMON);
    }

    public void setSummon(boolean summon) {
        this.set(SUMMON, summon);
    }

    public boolean getArmor() {
        return (Boolean)this.get(ARMOR);
    }

    public void setArmor(boolean armor) {
        this.set(ARMOR, armor);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("Summon", this.getSummon());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setSummon(tags.m_128471_("Summon"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 7.0f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (this.getArmor()) {
            Player player;
            amount = Math.min(1.0E-4f, amount);
            Entity entity = src.m_7639_();
            if (entity instanceof Player && !this.playerList.contains(player = (Player)entity)) {
                player.m_213846_((Component)this.getText("hora_cut").m_130940_(RED));
                this.playerList.add(player);
            }
        }
        return super.m_6469_(src, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_20919_ > 0 || this.f_19797_ % 7 != 0) {
            return;
        }
        if (this.isClient()) {
            float f1 = (float)this.m_20185_() - 0.5f + this.rand.nextFloat();
            float f2 = (float)this.m_20186_() + 0.25f + this.rand.nextFloat() * 1.5f;
            float f3 = (float)this.m_20189_() - 0.5f + this.rand.nextFloat();
            this.m_9236_().m_7106_((ParticleOptions)ParticleInit.NORMAL, (double)f1, (double)f2, (double)f3, 0.0, 0.0, 0.0);
        } else {
            ServerLevel sever = this.m_9236_().m_7654_().m_129880_(Level.f_46428_);
            int dayTime = 24000;
            long day = sever.m_46468_() / (long)dayTime;
            sever.m_8615_(12500L + day * (long)dayTime);
            LevelData levelData = sever.m_6106_();
            if (levelData instanceof ServerLevelData) {
                ServerLevelData data = (ServerLevelData)levelData;
                data.m_6399_(0);
                data.m_6398_(0);
                data.m_5557_(false);
                data.m_5565_(false);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_20919_ > 0) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (this.m_20186_() < target.m_20186_() || this.m_20186_() < target.m_20186_() + 2.0) {
            Vec3 vec = this.m_20184_();
            double y = Math.max(0.0, vec.f_82480_);
            y *= 0.25;
            y += (0.5 - y) * 0.25;
            this.m_20256_(new Vec3(vec.f_82479_, y, vec.f_82481_));
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.checkSpawnPos();
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
            this.checkPotion(PotionInit.reflash_effect, 9999, 0);
        }
        if (this.f_19797_ % 20 == 0) {
            List<LivingEntity> summonList = this.getSummonList();
            boolean isArmor = !summonList.isEmpty();
            this.setArmor(isArmor);
            if (isArmor && this.glowTime++ >= 20) {
                summonList.forEach(e -> this.addPotion((LivingEntity)e, MobEffects.f_19619_, 99999, 0));
            } else if (!isArmor) {
                this.glowTime = 0;
            }
        }
    }

    public void firstAttack(LivingEntity target) {
        if (!this.getArmor() && this.summonTime++ >= 600) {
            this.summonMob(target);
        }
        if (this.twilightTime++ >= 250) {
            this.twilightShot(target);
        }
        if (this.summonTime == 300) {
            this.setSummon(true);
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.f_19797_ % 2 == 0) {
            ++this.twilightTime;
        }
    }

    public void summonMob(LivingEntity target) {
        BlockPos sp = this.getSpawnPos();
        List<LivingEntity> targetList = this.getPlayerList(target);
        if (targetList.isEmpty() || sp == null) {
            return;
        }
        List<LivingEntity> summonList = this.getSummonList();
        int summonSize = summonList.isEmpty() ? 0 : summonList.size();
        boolean isHalf = this.isHalfHealth((LivingEntity)this);
        float addHealth = 1.0f + (float)targetList.size() * 0.05f;
        int count = Math.max(1, Math.min(16, 3 + targetList.size() - summonSize));
        Level world = this.m_9236_();
        for (int i = 0; i < count; ++i) {
            double x = (double)this.getSpawnPos().m_123341_() + (this.rand.nextDouble() - 0.5) * 20.0;
            double z = (double)this.getSpawnPos().m_123343_() + (this.rand.nextDouble() - 0.5) * 20.0;
            int setPosCount = 0;
            BlockPos pos = this.m_20183_();
            BlockPos summonPos = new BlockPos(x, this.m_20186_() + 1.0, z);
            while (!world.m_46859_(summonPos) && !world.m_8055_(summonPos).m_60713_(BlockInit.rune_character)) {
                summonPos = new BlockPos(pos.m_123341_() + this.getRand(this.rand, 20), pos.m_123342_(), pos.m_123343_() + this.getRand(this.rand, 20));
                if (setPosCount++ < 16) continue;
            }
            Mob entity = this.getEntity(world, addHealth, isHalf, i % 4 == 1);
            entity.m_6034_((double)summonPos.m_123341_() + 0.5, (double)summonPos.m_123342_() + 0.5, (double)summonPos.m_123343_() + 0.5);
            entity.m_6710_(targetList.get(this.rand.nextInt(targetList.size())));
            this.addEntity((Entity)entity);
        }
        this.summonTime = 0;
        this.setSummon(false);
        this.m_5496_(SoundInit.HORAMAGIC, 0.2f, 1.0f);
    }

    public void twilightShot(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            TwiLightShot magic = new TwiLightShot(this.m_9236_(), (LivingEntity)this);
            magic.m_6686_(x, y - xz * 0.065, z, 1.5f, 0.75f);
            magic.setAddDamage(magic.getAddDamage() + 10.0f);
            this.addEntity((Entity)magic);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.twilightTime = 0;
    }

    public Mob getEntity(Level world, float addHealth, boolean isHalf, boolean isBig) {
        ISMMob entity = null;
        if (isBig) {
            switch (this.rand.nextInt(5)) {
                case 0: {
                    entity = new SkullFrostRoyalGuard(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                    entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
                    break;
                }
                case 1: {
                    entity = new SkullFlameArcher(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
                    entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
                    break;
                }
                case 2: {
                    entity = new BlazeTempestTornado(world);
                    break;
                }
                case 3: {
                    entity = new EnderShadow(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                    this.addPotion((LivingEntity)entity, MobEffects.f_19597_, 99999, 0);
                    break;
                }
                case 4: {
                    entity = new DwarfZombieMaster(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_sword));
                    this.addPotion((LivingEntity)entity, MobEffects.f_19597_, 99999, 1);
                }
            }
            this.addPotion((LivingEntity)entity, MobEffects.f_19600_, 99999, 3);
            entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * 0.67f));
            entity.m_21153_(entity.m_21233_());
        } else {
            switch (this.rand.nextInt(8)) {
                case 0: {
                    entity = new BlazeTempest(world);
                    break;
                }
                case 1: {
                    entity = new EnderMage(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    break;
                }
                case 2: {
                    entity = new SkullFrost(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    break;
                }
                case 3: {
                    entity = new ArchSpider(world);
                    break;
                }
                case 4: {
                    entity = new SkullFlame(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                    break;
                }
                case 5: {
                    entity = new DwarfZombie(world);
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_pick));
                    break;
                }
                case 6: {
                    entity = new CreeperCalamity(world);
                    break;
                }
                case 7: {
                    entity = new WindWitch(world);
                }
            }
        }
        addHealth = isHalf ? addHealth * 1.325f : addHealth;
        entity.m_21051_(Attributes.f_22276_).m_22100_(Math.min(256.0, (double)(entity.m_21233_() * addHealth)));
        entity.m_21153_(entity.m_21233_());
        this.addPotion((LivingEntity)entity, PotionInit.resistance_blow, 99999, 5);
        this.addPotion((LivingEntity)entity, PotionInit.darkness_fog, 99999, 0);
        return entity;
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 10 && this.f_20919_ <= 300) {
            Level level;
            if (!this.isClient()) {
                ServerLevel world = this.m_9236_().m_7654_().m_129880_(Level.f_46428_);
                world.m_8615_(world.m_46468_() + 36L);
            }
            if (this.f_20919_ % 11 == 0) {
                this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
            }
            if (this.f_20919_ % 5 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)level;
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 2, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.f_20919_ >= 300 && !this.isClient()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
            List<LivingEntity> targetList = this.getSummonList();
            targetList.forEach(e -> e.m_21153_(0.0f));
        }
        this.getBossEvent().m_142711_(0.0f);
    }

    public List<LivingEntity> getSummonList() {
        return this.getEntityList(LivingEntity.class, (T e) -> e.m_21023_(PotionInit.darkness_fog), 64.0);
    }

    protected int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    @Override
    public void clearInfo() {
        this.tickTime = 0;
    }
}

