/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.ientity.IWitch;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.init.entity.projectile.TripleTornadoShot;
import sweetmagic.init.entity.projectile.WindStormShot;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public class WindWitchMaster
extends AbstractSMBoss
implements IWitch {
    private int tickTime = 0;
    private int recastTime = 0;
    private int recastSecondTime = 100;
    private List<Player> playerList = new ArrayList<Player>();
    public AnimationState magicAttackAnim = new AnimationState();
    private static final EntityDataAccessor<Boolean> TARGET = ISMMob.setData(WindWitchMaster.class, BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK = ISMMob.setData(WindWitchMaster.class, INT);
    private static final EntityDataAccessor<Integer> ARMOR = ISMMob.setData(WindWitchMaster.class, INT);
    private static final EntityDataAccessor<Boolean> RESURRECTION = ISMMob.setData(WindWitchMaster.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> CHARGE = ISMMob.setData(WindWitchMaster.class, BOOLEAN);
    private int windBlastTime = 0;
    private int windBlastCount = 2;
    private Map<Integer, BlockPos> posMap = new LinkedHashMap<Integer, BlockPos>();

    public WindWitchMaster(Level world) {
        super(EntityInit.windWitchMaster, world);
    }

    public WindWitchMaster(EntityType<WindWitchMaster> enType, Level world) {
        super(enType, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 512.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, false);
        this.define(RESURRECTION, false);
        this.define(CHARGE, false);
        this.define(ATTACK, 0);
        this.define(ARMOR, 0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    public int getAttackType() {
        return (Integer)this.get(ATTACK);
    }

    public void setAttackType(int attack) {
        this.set(ATTACK, attack);
    }

    public int getArmor() {
        return (Integer)this.get(ARMOR);
    }

    public void setArmor(int armor) {
        int oldArmor = this.getArmor();
        this.set(ARMOR, armor);
        if (oldArmor > 0 && armor <= 0) {
            if (!this.isClient() && !this.playerList.isEmpty()) {
                this.sendMSG(this.playerList, (Component)this.getText("wind_break").m_130940_(GREEN));
            }
            this.m_21195_(PotionInit.aether_barrier);
            this.m_21153_(Math.max(1.0f, this.m_21223_() - 100.0f));
        }
    }

    public void setResurrection(boolean isResurrection) {
        this.set(RESURRECTION, isResurrection);
    }

    public boolean getResurrection() {
        return (Boolean)this.get(RESURRECTION);
    }

    @Override
    public boolean getHard() {
        return super.getHard() || !this.getLectern();
    }

    @Override
    public boolean isTarget() {
        return (Boolean)this.get(TARGET);
    }

    @Override
    public boolean isCharge() {
        return (Boolean)this.get(CHARGE);
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    @Override
    public AnimationState getAnimaState() {
        return this.magicAttackAnim;
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        boolean isLectern = this.getLectern();
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, isLectern ? 7.5f : 5.5f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (isLectern) {
            amount = this.getLecternAction(src, amount, this.getArmor());
        }
        if (amount >= 2.0f && src.m_7640_() instanceof AbstractMagicShot && this.rand.nextFloat() >= 0.67f) {
            this.teleport();
        }
        return super.m_6469_(src, amount);
    }

    public float getLecternAction(DamageSource src, float amount, int armorSize) {
        if (armorSize > 0) {
            if (src.m_7640_() instanceof EvilArrow) {
                amount = this.getEvilDamage(amount, armorSize);
            } else {
                amount *= 0.25f;
                this.specialDamageCut(src, this.playerList, "wind_damecut");
            }
        } else {
            this.halfHealthTeleport();
        }
        return amount;
    }

    public float getEvilDamage(float amount, int armorSize) {
        amount = 25.0f / (float)this.getEntityList(Player.class, 80.0).size();
        return amount;
    }

    @Override
    protected boolean teleport() {
        BlockPos pos = this.getSpawnPos();
        if (!this.isClient() && this.m_6084_() && pos != null) {
            double x = (double)pos.m_123341_() + (this.rand.nextDouble() - 0.5) * 10.0;
            double y = (double)pos.m_123342_() + 1.5;
            double z = (double)pos.m_123343_() + (this.rand.nextDouble() - 0.5) * 10.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("is_target", this.isTarget());
        tags.m_128379_("isResurrection", this.getResurrection());
        tags.m_128379_("isCharge", this.isCharge());
        tags.m_128405_("armor", this.getArmor());
        tags.m_128405_("attackType", this.getAttackType());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.set(TARGET, tags.m_128471_("is_target"));
        this.set(RESURRECTION, tags.m_128471_("isResurrection"));
        this.set(CHARGE, tags.m_128471_("isCharge"));
        this.setArmor(tags.m_128451_("armor"));
        this.setAttackType(tags.m_128451_("attackType"));
        if (!this.getLectern()) {
            this.setBossEvent(BC_BLUE, NOTCHED_6);
        }
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.setArmor(this.getPlayer(Player.class).size() * 4);
        this.startInfo();
        return super.finalizeSpawn(info);
    }

    @Override
    public void startInfo() {
        super.startInfo();
        this.addPotion((LivingEntity)this, PotionInit.resurrection, 99999, 0);
        this.setResurrection(true);
    }

    @Override
    public float getBuffPower() {
        int armorCount;
        float damage = super.getBuffPower();
        if (!this.getLectern()) {
            damage += 8.0f;
            damage *= 1.25f;
        }
        if ((armorCount = this.getMaxHealthArmorCount()) > 0) {
            damage *= 1.0f + (float)armorCount * 0.35f;
        }
        return damage;
    }

    public void m_6667_(DamageSource src) {
        super.m_6667_(src);
        if (this.getResurrection()) {
            this.setResurrection(false);
            this.addPotion((LivingEntity)this, PotionInit.reflash_effect, 99999, 3);
            this.addPotion((LivingEntity)this, PotionInit.magic_damage_cause, 99999, 3);
            this.addPotion((LivingEntity)this, MobEffects.f_19600_, 99999, 3);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isClient() && this.tickTime++ > 10) {
            this.tickTime = 0;
            this.set(TARGET, this.m_5448_() != null);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.f_19797_ % 20 == 0 && !this.isArmorEmpty()) {
            this.setAetherBattier();
        }
        if (this.isHalfHealth((LivingEntity)this)) {
            if (this.getResurrection() && !this.m_21023_(PotionInit.resurrection)) {
                this.addPotion((LivingEntity)this, PotionInit.reflash_effect, 9999, 0);
            }
            if (this.recastSecondTime-- <= 0) {
                this.setCharge(true);
                this.secondPhaseSttack(target);
            }
        }
        if (this.recastTime-- > 0) {
            return;
        }
        this.firstPhaseSttack(target);
    }

    public void firstPhaseSttack(LivingEntity target) {
        if (this.getAttackType() == 0) {
            this.tornadoExplosion(target);
        } else {
            this.tripleTornado(target);
        }
    }

    public void secondPhaseSttack(LivingEntity target) {
        this.windStorm(target);
    }

    public void tornadoExplosion(LivingEntity target) {
        boolean isPlayer = this.isPlayer((Entity)target);
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), 64.0);
        if (entityList.isEmpty() || entityList.size() <= 0) {
            this.clearInfo();
            return;
        }
        double range = Math.min(32.0, 16.0 + (double)entityList.size() * 1.35);
        BlockPos pos = ((LivingEntity)entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList().get(0)).m_20183_();
        TripleTornadoShot entity = new TripleTornadoShot((LivingEntity)this);
        entity.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 1.0f, 0.0f);
        entity.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        entity.setHitDead(false);
        entity.setNotDamage(true);
        entity.setRange(range);
        entity.setAddDamage((this.getHard() ? 80.0f : 35.0f) + this.getBuffPower());
        entity.isPlayer = isPlayer;
        if (!this.isClient()) {
            this.addEntity((Entity)entity);
        }
        this.clearInfo();
    }

    public void tripleTornado(LivingEntity target) {
        boolean isPlayer = this.isPlayer((Entity)target);
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), 48.0);
        double range = Math.min(15.0, 8.0 + (double)entityList.size() * 0.325);
        int count = 0;
        for (LivingEntity livingEntity : entityList) {
            this.posMap.put(count, livingEntity.m_20183_());
            if (++count < 3) continue;
            break;
        }
        if (count < 3) {
            BlockPos basePos = this.m_20183_();
            int n = 32;
            for (int i = count; i < 3; ++i) {
                BlockPos pos;
                while (this.posMap.containsValue(pos = WorldHelper.offset(basePos, this.randRange(n), 0.0, this.randRange(n))) || this.m_9236_().m_46859_(pos.m_7495_())) {
                }
                this.posMap.put(i, pos);
            }
        }
        for (Map.Entry entry : this.posMap.entrySet()) {
            BlockPos pos = (BlockPos)entry.getValue();
            TripleTornadoShot entity = new TripleTornadoShot((LivingEntity)this);
            entity.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 1.0f, 0.0f);
            entity.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            entity.setHitDead(false);
            entity.setNotDamage(true);
            entity.setRange(range);
            entity.setAddDamage((this.getHard() ? 50.0f : 20.0f) + this.getBuffPower());
            entity.isPlayer = isPlayer;
            if (this.isClient()) continue;
            this.addEntity((Entity)entity);
        }
        this.clearInfo();
    }

    public void windStorm(LivingEntity target) {
        if (this.windBlastTime-- > 0) {
            return;
        }
        boolean isPlayer = this.isPlayer((Entity)target);
        float damage = target instanceof Warden ? 80.0f : 20.0f;
        for (int i = 0; i < 2; ++i) {
            WindStormShot entity = new WindStormShot(this.m_9236_(), (LivingEntity)this);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20189_() - this.m_20189_();
            double d3 = target.m_20227_(0.3333333333333333) - this.m_20186_();
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(d0, d3, d1), i == 0 ? 25.0f : -25.0f);
            entity.m_6686_(vec.m_122239_(), vec.m_122260_(), vec.m_122269_(), 1.0f, 0.0f);
            entity.setAddDamage(entity.getAddDamage() + damage);
            entity.setMaxLifeTime(120);
            entity.setRange(1.5);
            entity.setBlockPenetration(true);
            entity.isPlayer = isPlayer;
            this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
            if (this.isClient()) continue;
            this.addEntity((Entity)entity);
        }
        WindStormShot entity = new WindStormShot(this.m_9236_(), (LivingEntity)this);
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        entity.m_6686_(x, y - xz * 0.035, z, 1.0f, 0.0f);
        entity.setAddDamage(entity.getAddDamage() + damage + 10.0f);
        entity.setMaxLifeTime(120);
        entity.setRange(2.0);
        entity.setBlockPenetration(true);
        entity.isPlayer = isPlayer;
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        if (!this.isClient()) {
            this.addEntity((Entity)entity);
        }
        if (--this.windBlastCount > 0) {
            this.windBlastTime = 30;
        } else {
            this.clearInfo();
            this.recastSecondTime = 250 + this.rand.nextInt(100);
            this.windBlastCount = 2;
        }
    }

    public void setAetherBattier() {
        this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 200, this.getArmor() + 4);
    }

    @Override
    public boolean isArmorEmpty() {
        return this.getArmor() <= 0;
    }

    @Override
    public void clearInfo() {
        this.windBlastTime = 0;
        this.setAttackType(this.rand.nextInt(2));
        this.posMap.clear();
        this.recastTime = 150 + this.rand.nextInt(50);
        this.setCharge(false);
    }

    @Override
    public int sortEntity(Entity mob, Entity entity1, Entity entity2) {
        double distance2;
        if (entity1 == null || entity2 == null) {
            return 0;
        }
        double distance1 = mob.m_20280_(entity1);
        if (distance1 < (distance2 = mob.m_20280_(entity2))) {
            return 1;
        }
        if (distance1 > distance2) {
            return -1;
        }
        return 0;
    }
}

