/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.ientity.IWitch;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.BubbleMagicShot;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.entity.projectile.ExplosionMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.GravityMagicShot;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;

public class WitchSandryon
extends AbstractSMBoss
implements IWitch {
    private int magicTime = 350;
    private static final int MAX_MAGIC_TIME = 600;
    private int buffTime = 100;
    private static final int MAX_BUFF_TIME = 700;
    private int specialTime = 200;
    private static final int MAX_SPECIAL_TIME = 700;
    private int infiniteTime = 650;
    private static final int MAX_INFINITE_TIME = 900;
    private int magicCount = 0;
    private int specialType = -1;
    public AnimationState magicAttackAnim = new AnimationState();
    private static final EntityDataAccessor<Boolean> WAND_CHARGE = ISMMob.setData(WitchSandryon.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> INFINITE_WAND = ISMMob.setData(WitchSandryon.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> RESURRECTION = ISMMob.setData(WitchSandryon.class, BOOLEAN);
    private static final EntityDataAccessor<Integer> WAND_SIZE = ISMMob.setData(WitchSandryon.class, INT);

    public WitchSandryon(Level world) {
        super(EntityInit.witchSandryon, world);
    }

    public WitchSandryon(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 750;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(WAND_CHARGE, false);
        this.define(INFINITE_WAND, false);
        this.define(RESURRECTION, false);
        this.define(WAND_SIZE, 0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new AbstractSMBoss.SMRandomLookGoal((AbstractSMBoss)this){

            @Override
            public boolean m_8036_() {
                return !WitchSandryon.this.getWandCharge() && !WitchSandryon.this.getInfiniteWand() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 768.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    public void setWandCharge(boolean isWandCharge) {
        this.set(WAND_CHARGE, isWandCharge);
    }

    public boolean getWandCharge() {
        return (Boolean)this.get(WAND_CHARGE);
    }

    public void setInfiniteWand(boolean isInfiniteWand) {
        this.set(INFINITE_WAND, isInfiniteWand);
    }

    public boolean getInfiniteWand() {
        return (Boolean)this.get(INFINITE_WAND);
    }

    public void setResurrection(boolean isResurrection) {
        this.set(RESURRECTION, isResurrection);
    }

    public boolean getResurrection() {
        return (Boolean)this.get(RESURRECTION);
    }

    public void setWandSize(int wandSize) {
        this.set(WAND_SIZE, wandSize);
    }

    public int getWandSize() {
        return (Integer)this.get(WAND_SIZE);
    }

    @Override
    public boolean isCharge() {
        return this.getWandCharge() || this.getInfiniteWand();
    }

    @Override
    public AnimationState getAnimaState() {
        return this.magicAttackAnim;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("WandCharge", this.getWandCharge());
        tags.m_128379_("InfiniteWand", this.getInfiniteWand());
        tags.m_128379_("Resurrection", this.getResurrection());
        tags.m_128405_("WandSize", this.getWandSize());
        tags.m_128405_("magicTime", this.magicTime);
        tags.m_128405_("buffTime", this.buffTime);
        tags.m_128405_("specialTime", this.specialTime);
        tags.m_128405_("infiniteTime", this.infiniteTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setWandCharge(tags.m_128471_("WandCharge"));
        this.setInfiniteWand(tags.m_128471_("InfiniteWand"));
        this.setResurrection(tags.m_128471_("Resurrection"));
        this.setWandSize(tags.m_128451_("WandSize"));
        this.magicTime = tags.m_128451_("magicTime");
        this.buffTime = tags.m_128451_("buffTime");
        this.specialTime = tags.m_128451_("specialTime");
        this.infiniteTime = tags.m_128451_("infiniteTime");
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (attacker != null && attacker instanceof ISMMob) {
            return false;
        }
        amount = this.getBossDamageAmount(this.m_9236_(), this.defTime, src, amount, 7.0f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, (DamageSource)SMDamage.magicDamage, amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (this.getWandCharge()) {
            amount = Math.min(0.5f, amount);
            this.m_5496_(SoundEvents.f_11704_, 1.0f, 0.85f);
        } else if (this.getInfiniteWand()) {
            amount = Math.min(0.1f, amount);
            this.m_5496_(SoundEvents.f_11704_, 1.0f, 0.85f);
        }
        return super.m_6469_(src, amount);
    }

    public void m_6667_(DamageSource src) {
        super.m_6667_(src);
        if (!this.getResurrection()) {
            this.setResurrection(true);
            this.addPotion((LivingEntity)this, PotionInit.magic_damage_cause, 99999, 3);
            this.addPotion((LivingEntity)this, MobEffects.f_19600_, 99999, 3);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.setWandCharge(false);
            this.setInfiniteWand(false);
            return;
        }
        this.checkSpawnPos();
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
            this.checkPotion(PotionInit.reflash_effect, 9999, 0);
        }
        if (!this.getResurrection() && !this.m_21023_(PotionInit.resurrection)) {
            this.clearInfo();
        }
    }

    public void firstAttack(LivingEntity target) {
        if (!this.getInfiniteWand() && this.magicTime++ >= 450) {
            this.setWandCharge(true);
            this.setWandSize(6);
            if (this.magicTime >= 600 && this.magicTime % 10 == 0) {
                this.magicShot(target);
            }
        }
        if (this.buffTime++ >= 700) {
            this.addPotion(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        if (!this.getWandCharge() && this.infiniteTime++ >= 720) {
            this.setInfiniteWand(true);
            this.infiniteWand(target);
        }
        if (this.specialTime++ >= 580) {
            this.specialMagic(target);
        }
    }

    public void magicShot(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        boolean isResurrection = this.getResurrection();
        for (LivingEntity entity : targetList) {
            AbstractMagicShot magic = this.getMagicShot(entity, this.magicCount, entity instanceof Warden, isResurrection);
            this.addEntity((Entity)magic);
        }
        this.setWandSize(this.getWandSize() - 1);
        if (this.magicCount++ > 5) {
            this.magicTime = this.isHalfHealth((LivingEntity)this) ? -150 : 0;
            this.magicCount = 0;
            this.setWandCharge(false);
        }
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, int count, boolean isWarden, boolean isResurrection) {
        float dama = (float)this.m_21133_(Attributes.f_22281_) + (isWarden || isResurrection ? 30.0f : 15.0f);
        float dameRate = isWarden ? 1.5f : 1.0f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int level = isWarden ? 50 : 20;
        AbstractMagicShot entity = switch (count) {
            case 1 -> new FireMagicShot(this.m_9236_(), (LivingEntity)this);
            case 2 -> new CycloneMagicShot(this.m_9236_(), (LivingEntity)this);
            case 3 -> new FrostMagicShot(this.m_9236_(), (LivingEntity)this);
            case 4 -> new BubbleMagicShot(this.m_9236_(), (LivingEntity)this);
            case 5 -> new GravityMagicShot(this.m_9236_(), (LivingEntity)this);
            default -> new ExplosionMagicShot(this.m_9236_(), (LivingEntity)this);
        };
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.065, z, 2.0f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        entity.setHitDead(false);
        return entity;
    }

    public void addPotion(LivingEntity target) {
        block16: {
            block15: {
                if (!this.isHalfHealth((LivingEntity)this) && !this.getResurrection()) break block15;
                switch (this.rand.nextInt(5)) {
                    case 0: {
                        this.addPotion((LivingEntity)this, PotionInit.regeneration, 700, 0);
                        this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                        break;
                    }
                    case 1: {
                        this.addPotion((LivingEntity)this, PotionInit.aether_shield, 700, 1);
                        this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                        break;
                    }
                    case 2: {
                        this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 700, 3);
                        this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                        break;
                    }
                    case 3: {
                        this.m_5634_(this.m_21233_() * 0.0375f);
                        this.m_5496_(SoundInit.HEAL, 0.0625f, 1.0f);
                        Level level = this.m_9236_();
                        if (level instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)level;
                            this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123748_, 0.75, this.m_20183_(), 1.0, 0.1, 0.0);
                            break;
                        }
                        break block16;
                    }
                    case 4: {
                        this.addPotion((LivingEntity)this, PotionInit.recast_reduction, 600, 1);
                        this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                    }
                }
                break block16;
            }
            switch (this.rand.nextInt(5)) {
                case 0: {
                    this.addPotion((LivingEntity)this, PotionInit.magic_damage_cause, 600, 1);
                    this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                    break;
                }
                case 1: {
                    this.addPotion((LivingEntity)this, MobEffects.f_19600_, 600, 1);
                    this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                    break;
                }
                case 2: {
                    this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 600, 1);
                    this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                    break;
                }
                case 3: {
                    this.m_5634_(this.m_21233_() * 0.025f);
                    this.m_5496_(SoundInit.HEAL, 0.0625f, 1.0f);
                    Level level = this.m_9236_();
                    if (!(level instanceof ServerLevel)) break;
                    ServerLevel server = (ServerLevel)level;
                    this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123748_, 0.75, this.m_20183_(), 1.0, 0.1, 0.0);
                    break;
                }
                case 4: {
                    this.addPotion((LivingEntity)this, PotionInit.recast_reduction, 600, 0);
                    this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                }
            }
        }
        this.buffTime = 0;
    }

    public void infiniteWand(LivingEntity target) {
        if (this.infiniteTime < 900) {
            return;
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_) + 35.0f + (this.getResurrection() ? 10.0f : 0.0f);
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            List<MobEffectInstance> effecList = PlayerHelper.getEffectList(entity, PotionInit.BUFF);
            this.attackDamage((Entity)entity, (DamageSource)SMDamage.magicDamage, damage);
            effecList.forEach(p -> entity.m_21195_(p.m_19544_()));
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            entity.m_5496_(SoundEvents.f_11983_, 0.33f, 1.15f);
            player.m_213846_((Component)this.getText("buf_release").m_130940_(RED));
        }
        this.setInfiniteWand(false);
        this.infiniteTime = 0;
    }

    public void specialMagic(LivingEntity target) {
        if (this.specialType == -1) {
            this.specialType = this.rand.nextInt(3);
        }
        int x = (int)(this.m_20185_() + (double)this.getRandFloat(20.0f));
        int y = (int)this.m_20186_() + 5;
        int z = (int)(this.m_20189_() + (double)this.getRandFloat(20.0f));
        BlockPos pos = new BlockPos(x, y, z);
        float damage = (float)this.m_21133_(Attributes.f_22281_) + 7.0f;
        AbstractMagicShot magic = this.getSpecialMagic(target, this.specialType);
        magic.setAddDamage(magic.getAddDamage());
        magic.setRange(3.0);
        magic.setData(3);
        magic.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.0f, 0.0f);
        magic.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        magic.setAddDamage(magic.getAddDamage() + damage);
        magic.m_20256_(new Vec3(0.0, -0.67, 0.0));
        magic.setHitDead(false);
        magic.setChangeParticle(true);
        this.addEntity((Entity)magic);
        if (this.specialTime >= 700) {
            this.specialTime = 0;
            this.specialType = this.rand.nextInt(3);
        }
    }

    public AbstractMagicShot getSpecialMagic(LivingEntity target, int type) {
        return switch (type) {
            case 1 -> new FireMagicShot(this.m_9236_(), (LivingEntity)this);
            case 2 -> new FrostMagicShot(this.m_9236_(), (LivingEntity)this);
            default -> new ElectricMagicShot(this.m_9236_(), (LivingEntity)this);
        };
    }

    @Override
    public void clearInfo() {
        this.tickTime = 0;
        this.addPotion((LivingEntity)this, PotionInit.resurrection, 99999, 0);
    }
}

