/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class BelialFlameShot
extends AbstractMagicShot {
    public BelialFlameShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public BelialFlameShot(double x, double y, double z, Level world) {
        this(EntityInit.belialFlameShot, world);
        this.m_6034_(x, y, z);
    }

    public BelialFlameShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(null, this.getRange());
        super.m_8060_(result);
        this.m_146870_();
    }

    public void rangeAttack(LivingEntity living, double range) {
        this.m_5496_(SoundEvents.f_12089_, 1.0f, 1.0f);
        float damage = this.getDamage();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> this.attackDamage((LivingEntity)e, damage, false));
        for (LivingEntity livingEntity : entityList) {
            this.attackDamage(livingEntity, damage, false);
            this.addPotion(livingEntity, PotionInit.belial_flame, 240, 0);
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        double d = range * range;
        Iterable<BlockPos> pList = this.getPosRangeList(this.m_20183_(), range);
        for (BlockPos pos : pList) {
            if (!this.checkDistance(pos, d)) continue;
            double x = (double)pos.m_123341_() + this.rand.nextDouble() * 1.5 - 0.75;
            double y = (double)pos.m_123342_() + this.rand.nextDouble() * 0.25 + 0.25;
            double z = (double)pos.m_123343_() + this.rand.nextDouble() * 1.5 - 0.75;
            float xSpeed = this.getRandFloat(0.5f);
            float ySpeed = 0.25f + this.rand.nextFloat() * 0.25f;
            float zSpeed = this.getRandFloat(0.5f);
            sever.m_8767_((ParticleOptions)ParticleInit.BELIAL_FLAME, x, y, z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 0.25);
        }
    }

    @Override
    protected void spawnParticle() {
        float z;
        float y;
        float x;
        Vec3 vec = this.m_20184_();
        if (this.f_19797_ % 3 == 0) {
            x = (float)(-vec.f_82479_) / 30.0f;
            y = (float)(-vec.f_82480_) / 30.0f;
            z = (float)(-vec.f_82481_) / 30.0f;
            this.addParticle((ParticleOptions)ParticleInit.CYCLONE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), x, y, z);
        }
        x = (float)(-vec.f_82479_) / 20.0f;
        y = (float)(-vec.f_82480_) / 20.0f;
        z = (float)(-vec.f_82481_) / 20.0f;
        for (int i = 0; i < 6; ++i) {
            float f1 = (float)(this.m_20185_() - 0.5 + (double)this.rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)this.rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)this.rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.BELIAL_FLAME, f1, f2, f3, x + this.getRandFloat(0.075f), y + this.getRandFloat(0.075f), z + this.getRandFloat(0.075f));
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.FLAME;
    }
}

