/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.monster.boss.DemonsBelial;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class BelialSword
extends AbstractMagicShot {
    private float health = 256.0f;
    private float maxHealth = 256.0f;
    private static final EntityDataAccessor<Boolean> CHARGE = BelialSword.setEntityData(ISMMob.BOOLEAN);

    public BelialSword(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public BelialSword(double x, double y, double z, Level world) {
        this(EntityInit.belialSword, world);
        this.m_6034_(x, y, z);
    }

    public BelialSword(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.maxHealth = this.health = entity.m_21223_() * 0.25f;
        this.setRange(7.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(CHARGE, false);
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    public boolean getCharge() {
        return this.get(CHARGE);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isCharge", this.getCharge());
        tags.m_128350_("health", this.health);
        tags.m_128350_("maxHealth", this.maxHealth);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setCharge(tags.m_128471_("isCharge"));
        this.health = tags.m_128457_("health");
        this.maxHealth = tags.m_128457_("maxHealth");
    }

    @Override
    public void m_8119_() {
        this.checkOwner();
        if (this.getCharge()) {
            return;
        }
        super.m_8119_();
    }

    @Override
    protected void tickDespawn() {
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(null, this.getRange());
        super.m_8060_(result);
    }

    public void rangeAttack(LivingEntity living, double range) {
        float damage = this.getDamage();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> this.attackDamage((LivingEntity)e, damage, false));
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        double effectRange = range * range;
        Iterable<BlockPos> pList = this.getPosRangeList(this.m_20183_(), range);
        for (BlockPos pos : pList) {
            if (!this.checkDistance(pos, effectRange)) continue;
            double x = (double)pos.m_123341_() + this.rand.nextDouble() * 1.5 - 0.75;
            double y = (double)pos.m_123342_() + this.rand.nextDouble() * 0.25 + 0.25;
            double z = (double)pos.m_123343_() + this.rand.nextDouble() * 1.5 - 0.75;
            float xSpeed = this.getRandFloat(0.5f);
            float ySpeed = 0.25f + this.rand.nextFloat() * 0.25f;
            float zSpeed = this.getRandFloat(0.5f);
            sever.m_8767_((ParticleOptions)ParticleInit.BELIAL_FLAME, x, y, z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 0.25);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isClient()) {
            return true;
        }
        this.health -= Math.min(30.0f, amount);
        if (this.health <= 0.0f && this.maxHealth > 0.0f) {
            this.m_5496_(SoundEvents.f_12018_, 2.0f, 1.0f);
            Entity entity = this.m_37282_();
            if (entity instanceof DemonsBelial) {
                DemonsBelial entity2 = (DemonsBelial)entity;
                this.teleportParticle((ParticleOptions)ParticleInit.BELIAL_FLAME, this.m_20183_(), entity2.m_20183_(), 16);
                this.teleportParticle((ParticleOptions)ParticleInit.CYCLONE, this.m_20183_(), entity2.m_20183_(), 1);
                this.attackDamage((LivingEntity)entity2, this.maxHealth * 1.5f, false);
                this.maxHealth = 0.0f;
            }
            this.m_146870_();
        } else {
            this.m_5496_(SoundEvents.f_11683_, 2.0f, 1.0f);
        }
        return true;
    }

    public void teleportParticle(ParticleOptions par, BlockPos beforePos, BlockPos afterPos, int value) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        float pX = afterPos.m_123341_() - beforePos.m_123341_();
        float pY = afterPos.m_123342_() - beforePos.m_123342_();
        float pZ = afterPos.m_123343_() - beforePos.m_123343_();
        int count = Math.abs((int)(pX + pZ));
        for (int i = 0; i < count; ++i) {
            for (int k = 0; k < value; ++k) {
                float randX = this.getRandFloat(1.5f);
                float randY = this.getRandFloat(1.5f);
                float randZ = this.getRandFloat(1.5f);
                float ax = (float)beforePos.m_123341_() + 0.5f + randX + pX * ((float)i / (float)count);
                float ay = (float)beforePos.m_123342_() + 1.25f + randY + pY * ((float)i / (float)count);
                float az = (float)beforePos.m_123343_() + 0.5f + randZ + pZ * ((float)i / (float)count);
                sever.m_8767_(par, (double)ax, (double)ay, (double)az, 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.TOXIC;
    }
}

