/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class BloodMagicShot
extends AbstractMagicShot {
    public BloodMagicShot(EntityType<? extends BloodMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public BloodMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends BloodMagicShot>)EntityInit.bloodMagic, world);
        this.m_6034_(x, y, z);
    }

    public BloodMagicShot(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    public BloodMagicShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(5.0);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        living.f_19802_ = 0;
        if (this.getData() >= 1) {
            float rate = this.getData() == 1 ? 0.67f : 1.0f;
            this.rangeAttack(living.m_20183_(), this.getDamage() * rate, this.getRange());
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.getData() >= 1) {
            float rate = this.getData() == 1 ? 0.33f : 0.67f;
            this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * rate, this.getRange() * (double)0.67f);
        }
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        int data = this.getData();
        double effectRange = range * range;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isBladTarget(effectRange), range);
        if (data <= 2) {
            entityList.forEach(e -> this.attackDamage((LivingEntity)e, dame, false));
        } else {
            float baseAddAttack = (float)(data - 3) * 25.0f;
            entityList.forEach(e -> {
                this.attackDamage((LivingEntity)e, dame, false);
                this.addAttack((LivingEntity)e, dame, (int)(e.m_21233_() / (100.0f - baseAddAttack)));
            });
        }
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (data <= 1) {
            double moveSpeed = range * 0.175;
            double ySpeed = 0.45 + (range >= 4.0 ? range * -0.04 : 0.0);
            for (int i = -1; i < 3; ++i) {
                this.spawnParticleRing(server, (ParticleOptions)ParticleInit.BLOOD, range, bPos.m_6630_(i), ySpeed, moveSpeed);
            }
        } else if (data <= 2) {
            pos = this.m_20183_();
            SimpleParticleType particle = ParticleInit.CYCLE_BLOOD;
            for (double dis = 0.5; dis < range; dis += 0.5) {
                for (int i = 0; i < 8; ++i) {
                    this.spawnParticleCycle(server, (ParticleOptions)particle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, dis, (double)(i * 45) + dis * 12.0, true);
                }
            }
        } else {
            pos = this.m_20183_();
            SimpleParticleType par = ParticleInit.CYCLE_BLOOD_TORNADO;
            for (int y = -40; y < 8; ++y) {
                for (int i = 0; i < 16; ++i) {
                    this.spawnParticleCycle(server, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5 + this.rand.nextDouble() * 1.5 + (double)y * 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, 2.0, (float)i * 16.0f + (float)(y * 15), false);
                }
            }
            double x = (double)pos.m_123341_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            range = Math.sqrt(range);
            for (int i = 0; i < 4; ++i) {
                double y = (double)pos.m_123342_() + 1.0 + (double)i;
                for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
                    double rate = range * 0.75;
                    server.m_8767_((ParticleOptions)ParticleInit.BLOOD, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.85, (double)(this.rand.nextFloat() * 0.15f), Math.sin(degree) * 0.85, 1.0);
                }
            }
        }
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        float x = (float)pos.m_123341_() + this.getRandFloat(0.5f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.5f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.5f);
        for (int i = 0; i < 4; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.BLOOD, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 3;
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_) / 20.0f;
        float addY = (float)(-vec.f_82480_) / 20.0f;
        float addZ = (float)(-vec.f_82481_) / 20.0f;
        Random rand = this.rand;
        for (int i = 0; i < 6; ++i) {
            float x = addX + this.getRandFloat(0.075f);
            float y = addY + this.getRandFloat(0.075f);
            float z = addZ + this.getRandFloat(0.075f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)(rand.nextFloat() * 0.5f) + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.BLOOD, f1, f2, f3, x, y, z);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions particle, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(particle, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f), 1.0);
    }

    @Override
    public SMElement getElement() {
        return SMElement.DARK;
    }
}

