/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class BulletMagicShot
extends AbstractMagicShot {
    private int count = 0;
    private List<LivingEntity> taregetList = new ArrayList<LivingEntity>();
    private static final EntityDataAccessor<Integer> TARGET = BulletMagicShot.setEntityData(ISMMob.INT);

    public BulletMagicShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public BulletMagicShot(double x, double y, double z, Level world) {
        this(EntityInit.bulletMagic, world);
        this.m_6034_(x, y, z);
    }

    public BulletMagicShot(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, -1);
    }

    @Override
    public void m_8119_() {
        Entity target;
        if (!this.isClient()) {
            this.updateTarget();
        }
        if ((target = this.getTarget()) != null) {
            Vec3 vec = this.m_20184_();
            double mX = vec.m_7096_();
            double mY = vec.m_7098_();
            double mZ = vec.m_7094_();
            Vec3 arrowVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 lookVec = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_()).m_82546_(arrowVec);
            Vec3 arrowMotion = new Vec3(mX, mY, mZ);
            double theta = this.wrap180Radian(this.angleBetween(arrowMotion, lookVec));
            theta = this.clampAbs(theta, 1.5707963267948966);
            Vec3 crossVec = arrowMotion.m_82537_(lookVec).m_82541_();
            Vec3 adjustedVec = this.transform(crossVec, theta, arrowMotion);
            this.m_6686_(adjustedVec.f_82479_, adjustedVec.f_82480_, adjustedVec.f_82481_, 1.0f, 0.0f);
            this.m_20256_(this.m_20184_().m_82490_((double)1.1f));
        }
        this.spawnParticleSever();
        super.m_8119_();
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target != null) {
            return;
        }
        Entity owner = this.m_37282_();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> this.canTargetEffect((LivingEntity)e, owner) && e.m_6084_() && !this.taregetList.contains(e), this.getRange());
        if (entityList.isEmpty()) {
            return;
        }
        double distance = this.getRange() + 1.0;
        for (LivingEntity entity : entityList) {
            if (!(distance >= (double)entity.m_20270_((Entity)this))) continue;
            this.setTarget((Entity)entity);
        }
    }

    @Override
    protected void entityHit(LivingEntity living) {
        if ((double)this.knockback > 0.0) {
            double rate = 1.0 + (double)this.wandLevel * 0.05;
            double d0 = Math.max(0.0, 1.0 - living.m_21133_(Attributes.f_22278_)) * rate;
            Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * d0);
            if (vec3.m_82556_() > 0.0) {
                living.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
            }
        }
        if (this.getData() >= 3) {
            this.taregetList.add(living);
            this.setTarget(null);
            if (this.count++ > 3) {
                this.m_146870_();
            }
        }
    }

    @Override
    public void addAttack(LivingEntity entity, float dame, int addAttackCount) {
        if (addAttackCount <= 0) {
            return;
        }
        for (int i = 0; i < addAttackCount; ++i) {
            this.attackDamage(entity, dame * 0.25f, true);
        }
    }

    @Override
    public void addAttackEntity(Entity target, LivingEntity attacker, float dame, int addAttackCount) {
        if (addAttackCount <= 0) {
            return;
        }
        for (int i = 0; i < addAttackCount; ++i) {
            if (!target.m_6469_(DamageSource.m_19344_((Player)((Player)attacker)), dame * 0.25f)) continue;
            target.f_19802_ = 0;
        }
    }

    protected void spawnParticleSever() {
        Level level;
        if (this.f_19797_ < 3 || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        sever.m_8767_((ParticleOptions)ParticleInit.ORB, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.4470588266849518, 1.0, 0.6666666865348816, 1.0);
    }

    @Nullable
    private Entity getTarget() {
        return this.m_9236_().m_6815_(this.get(TARGET).intValue());
    }

    private void setTarget(Entity entity) {
        this.set(TARGET, entity == null ? -1 : entity.m_19879_());
    }

    @Override
    public SMElement getElement() {
        return SMElement.NON;
    }
}

