/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class CherryMagicShot
extends AbstractMagicShot {
    public CherryMagicShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public CherryMagicShot(double x, double y, double z, Level world) {
        this(EntityInit.cherryMagic, world);
        this.m_6034_(x, y, z);
    }

    public CherryMagicShot(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    public CherryMagicShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(4.0);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        if (this.getRange() > 0.0) {
            this.rangeAttack(living.m_20183_(), this.getDamage() * 0.85f, this.getRange());
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.getRange() > 0.0) {
            this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * 0.67f, this.getRange() * 0.75);
        }
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList;
        double effectRange = range * range;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            SimpleParticleType par = ParticleInit.CHERRY_BLOSSOMS_LARGE;
            if (this.getData() == 3) {
                for (eRange = 0.0; eRange < range; eRange += 1.0) {
                    for (i = 0; i < 5; ++i) {
                        this.spawnParticleRing2(server, (ParticleOptions)par, 1.0 + eRange * 1.5 - (double)i, bPos.m_6630_(i), -0.05, -0.1, -0.75);
                    }
                }
            } else {
                for (eRange = 0.0; eRange < range; eRange += 1.0) {
                    for (i = 0; i < Math.max(1, this.getData()); ++i) {
                        this.spawnParticleRing2(server, (ParticleOptions)par, 1.0 + eRange - (double)i, bPos.m_6630_(i), -0.05, 0.0, -0.35);
                    }
                }
            }
        }
        if ((entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range)).isEmpty()) {
            return;
        }
        boolean isPlayer = this.m_37282_() instanceof Player;
        int level2 = this.getData() == 3 ? 2 : Math.max(1, this.getData() - 1);
        for (LivingEntity entity : entityList) {
            if (!this.checkDistance(entity.m_20183_(), effectRange)) continue;
            this.attackDamage(entity, dame, false);
            for (int i = 0; i < 4; ++i) {
                this.attackDamage(entity, dame * 0.25f, false);
            }
            if (!isPlayer) continue;
            this.addPotion(entity, PotionInit.dig_poison_vulnerable, 1200, level2);
        }
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_ / 50.0);
        float addY = (float)(-vec.f_82480_ / 50.0);
        float addZ = (float)(-vec.f_82481_ / 50.0);
        Random rand = this.rand;
        for (int i = 0; i < 4; ++i) {
            float x = addX + this.getRandFloat(0.05f);
            float y = addY + this.getRandFloat(0.05f);
            float z = addZ + this.getRandFloat(0.05f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 5.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)(rand.nextFloat() * 0.5f) + vec.f_82480_ * (double)i / 5.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 5.0);
            this.addParticle((ParticleOptions)ParticleInit.CHERRY_BLOSSOMS_LARGE, f1, f2, f3, x, y, z);
        }
    }

    public void spawnParticleRing2(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, double speed) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        Random rand = this.rand;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            if (rand.nextFloat() >= 0.1f) continue;
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.65, ySpeed, Math.sin(degree) * 0.65, speed);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.EARTH;
    }
}

