/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.Arlaune;
import sweetmagic.init.entity.projectile.AbstractBossMagic;
import sweetmagic.util.PlayerHelper;

public class CherryRainMagic
extends AbstractBossMagic {
    private int rainTime = 0;
    private static final int MAX_RAINTIME = 150;
    private BlockPos pos = null;

    public CherryRainMagic(EntityType<? extends AbstractBossMagic> entityType, Level world) {
        super(entityType, world);
    }

    public CherryRainMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends AbstractBossMagic>)EntityInit.cherryRain, world);
        this.m_6034_(x, y, z);
    }

    public CherryRainMagic(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    @Override
    public void onUpdate() {
        if (this.target != null && this.target.m_6084_() || this.pos != null) {
            this.setRotInit();
            if (this.target != null && this.target.m_6084_()) {
                this.pos = this.target.m_20183_();
            }
            this.attackMagic(this.target);
        }
        if (!(this.rainTime > 0 || this.target != null && this.target.m_6084_() || this.f_19797_ % 8 != 0)) {
            this.setTarget();
        }
    }

    public void attackMagic(LivingEntity target) {
        if (this.isClient()) {
            return;
        }
        if ((double)this.rainTime >= 30.0) {
            Object targetList;
            double range = 15.0;
            if (this.rainTime % 10 == 0) {
                float damage = 3.0f + this.getAddDamage() * 0.1f;
                targetList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), this.getAABB(this.getPos(target), range));
                targetList.forEach(e -> this.attackDamage((LivingEntity)e, damage, true));
            }
            if ((targetList = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)targetList;
                Random rand = this.rand;
                BlockPos pos = this.getPos(target);
                Iterable<BlockPos> posList = this.getPosRangeList(pos, range);
                SimpleParticleType par = ParticleInit.CHERRY_BLOSSOMS_LARGE;
                for (BlockPos p : posList) {
                    if (rand.nextFloat() >= 0.04f) continue;
                    double x = (double)p.m_123341_() + rand.nextDouble() * 1.5 - 0.75;
                    double y = (double)p.m_123342_() + rand.nextDouble() * 1.5 - 0.75;
                    double z = (double)p.m_123343_() + rand.nextDouble() * 1.5 - 0.75;
                    float f1 = this.getRandFloat(0.1f);
                    float f2 = 0.2f + this.getRandFloat(0.1f);
                    float f3 = this.getRandFloat(0.1f);
                    server.m_8767_((ParticleOptions)par, x, y, z, 0, (double)f1, (double)f2, (double)f3, 1.0);
                }
            }
        }
        if (this.rainTime++ < 150) {
            return;
        }
        int data = this.getData();
        double range = data == 1 ? 20.0 : 16.5;
        float damage = (data == 1 ? 50.0f : 40.0f) + this.getAddDamage();
        List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), this.getAABB(this.getPos(target), range));
        for (LivingEntity entity : targetList) {
            Level p;
            List<MobEffectInstance> effecList;
            this.attackDamage(entity, damage, true);
            entity.m_5496_(SoundEvents.f_12089_, 1.5f, 1.0f);
            if (data == 1 && !(effecList = PlayerHelper.getEffectList(entity, PotionInit.BUFF)).isEmpty()) {
                entity.m_21195_(effecList.get(0).m_19544_());
            }
            if (!((p = this.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel sever = (ServerLevel)p;
            float x = (float)entity.f_19854_ + this.rand.nextFloat() * 0.5f;
            float y = (float)entity.m_20186_() + this.rand.nextFloat() * 0.5f + 1.5f;
            float z = (float)entity.f_19856_ + this.rand.nextFloat() * 0.5f;
            for (int i = 0; i < 8; ++i) {
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123815_, (double)x, (double)y, (double)z, 2, 0.0, 0.0, 0.0, (double)0.1f);
            }
        }
        this.rainTime = -50;
        this.pos = null;
    }

    public void setTarget() {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), 48.0);
        double dis = 0.0;
        this.target = null;
        for (LivingEntity entity : entityList) {
            if (this.target == null) {
                this.target = entity;
                dis = this.m_20280_((Entity)this.target);
                continue;
            }
            if (!(dis < this.m_20280_((Entity)entity))) continue;
            this.target = entity;
            dis = this.m_20280_((Entity)this.target);
        }
    }

    public BlockPos getPos(LivingEntity target) {
        if (this.target != null && this.target.m_6084_()) {
            return target.m_20183_();
        }
        if (this.pos != null) {
            return this.pos;
        }
        return this.m_20183_();
    }

    @Override
    public LivingEntity getEntity() {
        if (this.summon == null) {
            Arlaune queen = new Arlaune(this.m_9236_());
            queen.setMagic(true);
            this.summon = queen;
        }
        return this.summon;
    }

    @Override
    public SMElement getElement() {
        return SMElement.EARTH;
    }
}

