/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class DigMagicShot
extends AbstractMagicShot {
    private int breakCount = 0;

    public DigMagicShot(EntityType<? extends DigMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public DigMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends DigMagicShot>)EntityInit.digMagic, world);
        this.m_6034_(x, y, z);
    }

    public DigMagicShot(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = wandInfo.getStack();
    }

    public DigMagicShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void entityHit(LivingEntity living) {
        int time = 200 * this.getWandLevel();
        if (living instanceof Player && this.m_37282_() instanceof Player) {
            this.addPotion(living, MobEffects.f_19598_, time, 2);
        } else {
            this.addPotion(living, MobEffects.f_19599_, time, 2);
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        Player player;
        Entity entity;
        if (this.isClient()) {
            return;
        }
        if (this.m_37282_() == null || !((entity = this.m_37282_()) instanceof Player) || (player = (Player)entity).m_21023_(PotionInit.non_destructive)) {
            this.m_146870_();
            return;
        }
        if (this.getData() <= 1) {
            this.normalBreak(result.m_82425_());
        } else {
            this.rangeBreak(result.m_82425_(), result.m_82434_());
            if (this.breakCount++ >= this.getMaxBreak()) {
                this.m_146870_();
            }
        }
    }

    public void normalBreak(BlockPos pos) {
        Level world = this.m_9236_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (world.m_7702_(pos) != null || block.m_155943_() < 0.0f) {
            this.m_146870_();
            return;
        }
        ArrayList dropList = new ArrayList();
        int sumXP = 0;
        if (this.canBreakBlock(block, state)) {
            this.m_146870_();
            return;
        }
        int data = this.getData();
        if (data == 0 && !this.getSilk()) {
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)((Player)this.m_37282_()), (ItemStack)new ItemStack((ItemLike)Items.f_42390_)));
                Block block2 = state.m_60734_();
                if (block2 instanceof DropExperienceBlock) {
                    DropExperienceBlock exp = (DropExperienceBlock)block2;
                    sumXP += exp.getExpDrop(state, (LevelReader)world, this.getRandom(), pos, 0, 0);
                }
            }
        } else {
            dropList.addAll(block.m_7381_(state, this.getLoot(pos)));
        }
        this.breakBlock(block, state, pos);
        if (!dropList.isEmpty()) {
            BlockPos pPos = this.m_37282_().m_20183_();
            dropList.forEach(s -> world.m_7967_((Entity)new ItemEntity(world, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), s)));
            if (sumXP > 0) {
                world.m_7967_((Entity)new ExperienceOrb(world, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), sumXP));
            }
        }
        if (!this.getBlockPenetration()) {
            this.m_146870_();
        }
    }

    public void rangeBreak(BlockPos pos, Direction face) {
        if (this.breakCount == 0) {
            Vec3 vec3 = this.m_20184_();
            double x = vec3.f_82479_;
            double y = vec3.f_82480_;
            double z = vec3.f_82481_;
            switch (face) {
                case NORTH: {
                    y = 0.0;
                    x = 0.0;
                    break;
                }
                case SOUTH: {
                    y = 0.0;
                    x = 0.0;
                    break;
                }
                case EAST: {
                    z = 0.0;
                    y = 0.0;
                    break;
                }
                case WEST: {
                    z = 0.0;
                    y = 0.0;
                    break;
                }
                case UP: {
                    z = 0.0;
                    x = 0.0;
                    break;
                }
                case DOWN: {
                    z = 0.0;
                    x = 0.0;
                }
            }
            this.m_20256_(new Vec3(x, y, z));
        }
        Iterable<BlockPos> posList = this.getPosList(pos, 1.0);
        ArrayList dropList = new ArrayList();
        int sumXP = 0;
        Player player = (Player)this.m_37282_();
        ItemStack PICK = new ItemStack((ItemLike)Items.f_42390_);
        for (BlockPos p : posList) {
            BlockState state = this.m_9236_().m_8055_(p);
            Block block = state.m_60734_();
            if (this.canBreakBlock(block, state) || this.m_9236_().m_7702_(p) != null || block.m_155943_() < 0.0f) continue;
            if (!this.getSilk()) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)p, null, (Entity)player, (ItemStack)PICK));
                    Block block2 = state.m_60734_();
                    if (block2 instanceof DropExperienceBlock) {
                        DropExperienceBlock exp = (DropExperienceBlock)block2;
                        sumXP += exp.getExpDrop(state, (LevelReader)this.m_9236_(), this.getRandom(), pos, 0, 0);
                    }
                }
            } else {
                dropList.addAll(block.m_7381_(state, this.getLoot(pos)));
            }
            this.breakBlock(block, state, p);
        }
        if (!dropList.isEmpty()) {
            BlockPos pPos = this.m_37282_().m_20183_();
            dropList.forEach(s -> this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), s)));
            if (sumXP > 0) {
                this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), sumXP));
            }
        }
    }

    public boolean canBreakBlock(Block block, BlockState state) {
        Material material = state.m_60767_();
        return state.m_60795_() || material == Material.f_76305_ || material == Material.f_76307_ || block == Blocks.f_50752_ || block == Blocks.f_50258_;
    }

    public void breakBlock(Block block, BlockState state, BlockPos pos) {
        this.m_9236_().m_46961_(pos, false);
        this.m_9236_().m_7471_(pos, false);
        this.m_146850_(GameEvent.f_157794_);
    }

    public LootContext.Builder getLoot(BlockPos pos) {
        ItemStack tool = new ItemStack((ItemLike)ItemInit.alt_pick);
        tool.m_41663_(Enchantments.f_44985_, 1);
        return new LootContext.Builder((ServerLevel)this.m_9236_()).m_230911_(this.getRandom()).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78984_(LootContextParams.f_81462_, (Object)this.m_9236_().m_7702_(pos));
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_) / 20.0f;
        float addY = (float)(-vec.f_82480_) / 20.0f;
        float addZ = (float)(-vec.f_82481_) / 20.0f;
        this.addParticle((ParticleOptions)ParticleInit.DIG, this.m_20185_(), this.m_20186_(), this.m_20189_(), addX, addY, addZ);
    }

    @Override
    public SMElement getElement() {
        return SMElement.EARTH;
    }
}

