/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class ElectricMagicShot
extends AbstractMagicShot {
    public boolean isRangeAttack = false;
    public List<LivingEntity> targetList = new ArrayList<LivingEntity>();
    private static final EntityDataAccessor<Integer> TICKTIME = ElectricMagicShot.setEntityData(ISMMob.INT);
    private static final EntityDataAccessor<Integer> MAX_COUNT = ElectricMagicShot.setEntityData(ISMMob.INT);

    public ElectricMagicShot(EntityType<? extends ElectricMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public ElectricMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends ElectricMagicShot>)EntityInit.electricMagic, world);
        this.m_6034_(x, y, z);
    }

    public ElectricMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public ElectricMagicShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(TICKTIME, 0);
        this.define(MAX_COUNT, 0);
    }

    public void addTick() {
        this.set(TICKTIME, this.getTick() + 1);
    }

    public int getTick() {
        return this.get(TICKTIME);
    }

    public void setMaxCount(int maxCount) {
        this.set(MAX_COUNT, maxCount);
    }

    public int getMaxCount() {
        return this.get(MAX_COUNT);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("maxCount", this.getMaxCount());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setMaxCount(tags.m_128451_("maxCount"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isClient()) {
            this.addTick();
        }
        if (this.isRangeAttack) {
            this.rangeAttack();
        }
    }

    @Override
    protected void entityHit(LivingEntity living) {
        this.rangeAttack(this.getDamage() * this.getDamageRate() * 0.75f, this.getRange());
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(this.getDamage() * this.getDamageRate() * 0.5f, this.getRange() * (double)0.67f);
        this.m_146870_();
    }

    public void rangeAttack(float dame, double range) {
        float size;
        if (this.isRangeAttack || this.m_9236_().m_5776_()) {
            return;
        }
        boolean change = this.getChangeParticle();
        float f = size = change ? 0.15f : 1.5f;
        if (change && this.rand.nextFloat() <= 0.15f) {
            size = 0.0f;
        }
        this.m_5496_(SoundEvents.f_12090_, size, 1.0f);
        this.m_5496_(SoundEvents.f_12089_, 1.5f, 1.0f);
        List<Object> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        if (entityList.isEmpty()) {
            return;
        }
        entityList = entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList();
        dame *= 1.0f + (this.m_20069_() ? 0.5f : 0.0f);
        boolean isTier3 = this.getData() >= 2;
        int addAttack = this.getAddAttack();
        for (int i = 0; i < Math.min(this.getMaxCount(), entityList.size()); ++i) {
            LivingEntity entity = (LivingEntity)entityList.get(i);
            this.attackDamage(entity, dame, false);
            if (isTier3) {
                this.addPotion(entity, PotionInit.lightning_wind_vulnerable, 1200, this.getData() - 2);
            }
            this.addAttack(entity, dame, addAttack);
        }
    }

    public void rangeAttack() {
        Entity owner = this.m_37282_();
        float damage = this.getDamage();
        double range = this.getRange();
        ArrayList<LivingEntity> attackList = new ArrayList<LivingEntity>();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        for (LivingEntity entity : entityList) {
            if (!this.canTargetEffect(entity, owner) || attackList.contains(entity) || this.getHitDead() && this.targetList.contains(entity)) continue;
            this.attackDamage(entity, damage, false);
            attackList.add(entity);
        }
        this.targetList.addAll(attackList);
    }

    public int sortEntity(Entity mob, Entity entity1, Entity entity2) {
        double distance2;
        if (entity1 == null || entity2 == null) {
            return 0;
        }
        boolean isBoss1 = entity1.m_6095_().m_204039_(TagInit.BOSS);
        boolean isBoss2 = entity2.m_6095_().m_204039_(TagInit.BOSS);
        if (isBoss1 && isBoss2) {
            return 0;
        }
        if (isBoss1) {
            return -1;
        }
        if (isBoss2) {
            return 1;
        }
        double distance1 = mob.m_20280_(entity1);
        if (distance1 > (distance2 = mob.m_20280_(entity2))) {
            return 1;
        }
        if (distance1 < distance2) {
            return -1;
        }
        return 0;
    }

    public float getDamageRate() {
        return switch (this.getData()) {
            case 0 -> 1.0f;
            case 1 -> 1.25f;
            default -> 2.0f;
        };
    }

    @Override
    public SMElement getElement() {
        return SMElement.LIGHTNING;
    }
}

