/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.QueenFrost;
import sweetmagic.init.entity.projectile.AbstractBossMagic;

public class FrostLaserMagic
extends AbstractBossMagic {
    public FrostLaserMagic(EntityType<? extends FrostLaserMagic> entityType, Level world) {
        super((EntityType<? extends AbstractBossMagic>)entityType, world);
    }

    public FrostLaserMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends FrostLaserMagic>)EntityInit.frostLaser, world);
        this.m_6034_(x, y, z);
    }

    public FrostLaserMagic(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    @Override
    public void onUpdate() {
        if (this.target != null) {
            this.setRotInit();
            this.attackParticle();
            if (this.f_19797_ % 8 == 0) {
                this.attackMagic();
            }
        }
        if (!(this.target != null && this.target.m_6084_() || this.f_19797_ % 8 != 0)) {
            this.setTarget();
        }
    }

    public void attackParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Random rand = this.rand;
        BlockPos p = this.target.m_20183_();
        SimpleParticleType par = ParticleInit.FROST_LASER;
        for (int i = 0; i < 10; ++i) {
            if (rand.nextFloat() >= 0.65f) continue;
            float f1 = (float)this.m_20185_() + rand.nextFloat() - 0.5f;
            float f2 = (float)this.m_20186_() + 0.5f;
            float f3 = (float)this.m_20189_() + rand.nextFloat() - 0.5f;
            float x = (float)((double)p.m_123341_() - this.m_20185_() + (double)this.getRandFloat(1.5f)) * 0.125f;
            float y = (float)((double)p.m_123342_() - this.m_20186_() + (double)this.getRandFloat(1.5f)) * 0.125f;
            float z = (float)((double)p.m_123343_() - this.m_20189_() + (double)this.getRandFloat(1.5f)) * 0.125f;
            server.m_8767_((ParticleOptions)par, (double)f1, (double)f2, (double)f3, 0, (double)x, (double)y, (double)z, 1.0);
        }
    }

    public void attackMagic() {
        ArrayList<LivingEntity> entityAllList = new ArrayList<LivingEntity>();
        double disX = this.target.f_19854_ - this.f_19854_;
        double disY = this.target.f_19855_ - this.f_19855_;
        double disZ = this.target.f_19856_ - this.f_19856_;
        int data = this.getData();
        float damage = (data == 1 ? 4.0f : 2.5f) + this.getAddDamage() * 0.1f;
        for (int i = 0; i < 36; ++i) {
            double dis = (double)(i + 1) / 36.0;
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getAABB(disX * dis, disY * dis, disZ * dis, false)).stream().filter(e -> e.m_6084_() && e instanceof Enemy && !entityAllList.contains(e)).toList();
            entityAllList.addAll(entityList);
            for (LivingEntity target : entityList) {
                float newDamage = damage * (data == 1 && target.m_21023_(PotionInit.frost) ? 1.5f : 1.0f);
                this.attackDamage(target, newDamage, true);
                if (data != 1) continue;
                this.addPotion(target, PotionInit.frost, 0, 600);
            }
        }
    }

    public void setTarget() {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), 48.0);
        double dis = 0.0;
        this.target = null;
        for (LivingEntity entity : entityList) {
            if (this.target == null) {
                this.target = entity;
                dis = this.m_20280_((Entity)this.target);
                continue;
            }
            if (!(dis < this.m_20280_((Entity)entity))) continue;
            this.target = entity;
            dis = this.m_20280_((Entity)this.target);
        }
    }

    @Override
    public LivingEntity getEntity() {
        if (this.summon == null) {
            QueenFrost queen = new QueenFrost(this.m_9236_());
            queen.setArmor(3);
            queen.setMagic(true);
            this.summon = queen;
        }
        return this.summon;
    }

    @Override
    public SMElement getElement() {
        return SMElement.FROST;
    }
}

