/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.monster.boss.HolyAngel;
import sweetmagic.init.entity.projectile.AbstractBossMagic;

public class HolyBusterMagic
extends AbstractBossMagic {
    private int chargeTime = 0;
    private static final int MAX_CHARGETIME = 80;
    private Map<Integer, BlockPos> posMap = new LinkedHashMap<Integer, BlockPos>();

    public HolyBusterMagic(EntityType<? extends HolyBusterMagic> entityType, Level world) {
        super((EntityType<? extends AbstractBossMagic>)entityType, world);
    }

    public HolyBusterMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends HolyBusterMagic>)EntityInit.holyBusert, world);
        this.m_6034_(x, y, z);
    }

    public HolyBusterMagic(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    @Override
    public void onUpdate() {
        if (this.target != null) {
            this.setRotInit();
            this.attackParticle();
            if (this.chargeTime % 30 == 0) {
                this.attackParticle();
            }
            if (this.chargeTime++ >= 80 && this.f_19797_ % 6 == 0) {
                this.attackMagic();
            }
        }
        if (!(this.target != null && this.target.m_6084_() || this.f_19797_ % 8 != 0)) {
            this.setTarget();
        }
    }

    public void attackParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int count = 18;
        double range = this.getData() == 1 ? 16.75 : 10.0;
        Random rand = this.rand;
        SimpleParticleType par = ParticleInit.CYCLE_ELECTRIC;
        for (BlockPos pos : this.posMap.values()) {
            if (pos == null) {
                return;
            }
            this.spawnParticleCycle(server, pos, range + 1.15, rand, count, (ParticleOptions)par);
            this.spawnParticleCycle(server, pos, range - 3.85, rand, count, (ParticleOptions)par);
            this.spawnParticleCycle(server, pos, range - 7.85, rand, count, (ParticleOptions)par);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, BlockPos pos, double range, Random rand, int count, ParticleOptions par) {
        for (int i = 0; i < count; ++i) {
            this.spawnParticleCycle(server, par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, range, (float)i * 20.0f, false);
        }
    }

    @Override
    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f), 1.0);
    }

    public void setTargetPos() {
        if (!this.posMap.isEmpty()) {
            return;
        }
        int maxTarget = this.getData() == 1 ? 12 : 8;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e.m_6084_() && e instanceof Enemy, 48.0);
        int maxLoop = Math.min(maxTarget, entityList.size());
        for (int i = 0; i < maxLoop; ++i) {
            this.posMap.put(i, entityList.get(i).m_20183_());
        }
        if (10 > maxLoop && this.target != null) {
            int mapRange = 32;
            Random rand = this.rand;
            BlockPos basePos = this.target.m_20183_();
            for (int i = maxLoop; i < maxTarget; ++i) {
                BlockPos pos;
                while (this.posMap.containsValue(pos = new BlockPos(basePos.m_123341_() + this.getRandRange(rand, mapRange), basePos.m_123342_(), basePos.m_123343_() + this.getRandRange(rand, mapRange)))) {
                }
                this.posMap.put(i, pos);
            }
        }
    }

    public int getRandRange(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public void attackMagic() {
        int data = this.getData();
        double range = data == 1 ? 22.5 : 12.5;
        float damage = (data == 1 ? 50.0f : 25.0f) + this.getAddDamage();
        this.setTargetPos();
        Iterator<Map.Entry<Integer, BlockPos>> iterator = this.posMap.entrySet().iterator();
        if (iterator.hasNext()) {
            LivingEntity target2;
            Map.Entry<Integer, BlockPos> map = iterator.next();
            BlockPos pos = map.getValue();
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getAABB(pos, range)).stream().filter(e -> e.m_6084_() && e instanceof Enemy && this.checkDistances(pos, e.m_20183_(), range * range)).toList();
            for (LivingEntity target2 : entityList) {
                this.attackDamage(target2, damage, true);
                this.addAttack(target2, this.getDamage(), 1 + (int)(this.getRange() / 3.0));
                if (data != 1) continue;
                if (target2.m_21023_(MobEffects.f_19619_)) {
                    target2.m_21153_(Math.min(1.0f, target2.m_21223_() - 10.0f));
                }
                this.addPotion(target2, MobEffects.f_19619_, 0, 600);
            }
            this.posMap.remove(map.getKey());
            if (this.posMap.isEmpty()) {
                this.chargeTime = 0;
                this.posMap.clear();
            }
            if ((target2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)target2;
                Random rand = this.rand;
                Iterable<BlockPos> posList = this.getPosList(pos, range);
                for (BlockPos p : posList) {
                    if (!this.checkDistances(pos, p, range * range) || rand.nextFloat() >= 0.25f) continue;
                    float x = (float)p.m_123341_() + rand.nextFloat() - 0.5f;
                    float y = (float)p.m_123342_() + rand.nextFloat() - 0.5f;
                    float z = (float)p.m_123343_() + rand.nextFloat() - 0.5f;
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y, (double)z, 0, 0.0, (double)(rand.nextFloat() * 0.75f), 0.0, 1.0);
                }
            }
            this.m_9236_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11913_, this.m_5720_(), 2.0f, 1.0f);
            return;
        }
    }

    public void setTarget() {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), 48.0);
        double dis = 0.0;
        this.target = null;
        for (LivingEntity entity : entityList) {
            if (this.target == null) {
                this.target = entity;
                dis = this.m_20280_((Entity)this.target);
                continue;
            }
            if (!(dis < this.m_20280_((Entity)entity))) continue;
            this.target = entity;
            dis = this.m_20280_((Entity)this.target);
        }
    }

    @Override
    public LivingEntity getEntity() {
        if (this.summon == null) {
            HolyAngel queen = new HolyAngel(this.m_9236_());
            queen.setORU(4);
            queen.setMagic(true);
            this.summon = queen;
        }
        return this.summon;
    }

    @Override
    public SMElement getElement() {
        return SMElement.SHINE;
    }
}

