/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class LightningRod
extends AbstractMagicShot {
    private static final EntityDataAccessor<Boolean> LIGHNING = LightningRod.setEntityData(ISMMob.BOOLEAN);

    public LightningRod(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public LightningRod(double x, double y, double z, Level world) {
        this(EntityInit.lightningRod, world);
        this.m_6034_(x, y, z);
    }

    public LightningRod(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = wandInfo.getStack();
    }

    public LightningRod(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(LIGHNING, false);
    }

    public boolean getLighning() {
        return this.get(LIGHNING);
    }

    @Override
    public void m_8119_() {
        int maxTime = this.getMaxLifeTime();
        if (!this.isClient() && this.f_19797_ + 200 > maxTime) {
            Level level;
            if (this.f_19797_ + 5 > maxTime) {
                this.set(LIGHNING, true);
            }
            if (this.f_19797_ >= maxTime) {
                this.rangeAttack(this.getDamage(), this.getRange());
                this.m_146870_();
            }
            if (this.f_19797_ % 2 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                BlockPos pos = this.m_20183_();
                float range = (float)this.getRange();
                for (int i = 0; i < 3; ++i) {
                    double x = (float)pos.m_123341_() + this.getRandFloat(range);
                    double z = (float)pos.m_123343_() + this.getRandFloat(range);
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, this.f_19855_ + 0.25, z, 0, (double)0.2627451f, 0.6784313917160034, 0.40392157435417175, 1.0);
                }
            }
        }
        super.m_8119_();
    }

    public void rangeAttack(float dame, double range) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> !(e instanceof ISMMob), range);
        if (entityList.isEmpty()) {
            return;
        }
        this.m_5496_(SoundEvents.f_12090_, 0.5f, 1.0f);
        this.m_5496_(SoundEvents.f_12089_, 0.5f, 1.0f);
        for (LivingEntity entity : entityList) {
            this.attackDamage(entity, dame, false);
            this.addPotion(entity, PotionInit.lightning_wind_vulnerable, 1200, 1);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.LIGHTNING;
    }
}

