/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class RockBlastMagicShot
extends AbstractMagicShot {
    private static final ItemStack ROCK = new ItemStack((ItemLike)Blocks.f_50069_);
    private static final ItemStack IRON = new ItemStack((ItemLike)Blocks.f_50075_);
    private static final ItemStack DIAMON = new ItemStack((ItemLike)Blocks.f_50090_);
    private static final ItemStack NETHERITE = new ItemStack((ItemLike)Blocks.f_50721_);

    public RockBlastMagicShot(EntityType<? extends RockBlastMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public RockBlastMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends RockBlastMagicShot>)EntityInit.rockBlastMagic, world);
        this.m_6034_(x, y, z);
    }

    public RockBlastMagicShot(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    public RockBlastMagicShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void spawnParticle() {
        if (this.f_19797_ < 3) {
            return;
        }
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_ / 80.0);
        float y = (float)(-vec.f_82480_ / 80.0);
        float z = (float)(-vec.f_82481_ / 80.0);
        Random rand = this.rand;
        for (int i = 0; i < 6; ++i) {
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() + 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.DIG, f1, f2, f3, x, y, z);
        }
    }

    public BlockState getRockState() {
        return ((BlockItem)this.getRockStack().m_41720_()).m_40614_().m_49966_();
    }

    public ItemStack getRockStack() {
        return switch (this.getData()) {
            case 1 -> IRON;
            case 2 -> DIAMON;
            case 3 -> NETHERITE;
            default -> ROCK;
        };
    }

    @Override
    public SMElement getElement() {
        return SMElement.EARTH;
    }
}

