/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class ShootingStar
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> POSY = ShootingStar.setEntityData(ISMMob.INT);
    private static final EntityDataAccessor<Boolean> CHARGE = ShootingStar.setEntityData(ISMMob.BOOLEAN);

    public ShootingStar(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
        this.setMaxLifeTime(120);
    }

    public ShootingStar(double x, double y, double z, Level world) {
        this(EntityInit.shootingStar, world);
        this.m_6034_(x, y, z);
    }

    public ShootingStar(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(POSY, 0);
        this.define(CHARGE, false);
    }

    @Override
    public void m_8119_() {
        this.checkOwner();
        if (this.getCharge()) {
            return;
        }
        super.m_8119_();
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(null, this.getRange());
        super.m_8060_(result);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        this.rangeAttack(living, this.getRange() * (double)1.15f);
    }

    public void rangeAttack(LivingEntity living, double range) {
        this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        float damage = this.getDamage();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> this.attackDamage((LivingEntity)e, damage, false));
        this.m_146870_();
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        sever.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 2, 0.0, 0.0, 0.0, 0.0);
        BlockPos pos = this.m_20183_();
        float x = (float)pos.m_123341_() + this.getRandFloat(0.5f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.5f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.5f);
        for (int i = 0; i < 16; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.TWILIGHTLIGHT, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    public boolean getCharge() {
        return this.get(CHARGE);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isCharge", this.getCharge());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setCharge(tags.m_128471_("isCharge"));
    }

    @Override
    protected void spawnParticle() {
        this.addParticle((ParticleOptions)ParticleInit.ORB, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.4470588266849518, 1.0, 0.6666666865348816);
    }

    @Override
    public SMElement getElement() {
        return SMElement.SHINE;
    }
}

