/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class SickleShot
extends AbstractMagicShot {
    public SickleShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public SickleShot(double x, double y, double z, Level world) {
        this(EntityInit.sickleShot, world);
        this.m_6034_(x, y, z);
    }

    public SickleShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82490_(0.8));
        if (this.f_19797_ % 10 == 0) {
            this.rangeAttack(this.m_20183_(), this.getDamage(), this.getRange());
        }
    }

    public void rangeAttack(BlockPos pos, float dame, double range) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(pos, range), range);
        this.m_5496_(SoundInit.SWING, 0.2f, 1.0f);
        for (LivingEntity entity : entityList) {
            this.attackDamage(entity, this.getDamage() * 0.25f, false);
        }
    }

    public void spawnParticle(ServerLevel server) {
        if (this.f_19797_ % 30 == 0) {
            this.spawnParticleCycle(server, this.f_19854_, this.f_19855_ + 1.15, this.f_19856_, 0.85, this.rand, 10);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, double x, double y, double z, double range, Random rand, int count) {
        SimpleParticleType par = ParticleInit.CYCLE_TOXIC;
        for (int i = 0; i < count; ++i) {
            this.spawnParticleCycle(server, (ParticleOptions)par, x, y, z, Direction.UP, range, (float)i * 36.0f, false);
            this.spawnParticleCycle(server, (ParticleOptions)par, x, y, z, Direction.NORTH, range, (float)i * 36.0f, false);
            this.spawnParticleCycle(server, (ParticleOptions)par, x, y, z, Direction.EAST, range, (float)i * 36.0f, false);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f), 1.0);
    }

    public Predicate<LivingEntity> getFilter(BlockPos pos, double range) {
        return e -> !e.m_5833_() && e.m_6084_() && this.checkDistances(pos, e.m_20183_(), range * range);
    }

    public boolean isPlayer(Entity entity) {
        return entity instanceof Player || entity instanceof AbstractSummonMob;
    }

    @Override
    public SMElement getElement() {
        return SMElement.TOXIC;
    }
}

