/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class SoulBlazeShot
extends AbstractMagicShot {
    public SoulBlazeShot(EntityType<? extends SoulBlazeShot> entityType, Level world) {
        super(entityType, world);
    }

    public SoulBlazeShot(double x, double y, double z, Level world) {
        this((EntityType<? extends SoulBlazeShot>)EntityInit.soulBlazeShot, world);
        this.m_6034_(x, y, z);
    }

    public SoulBlazeShot(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(wandInfo);
    }

    public SoulBlazeShot(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void entityHit(LivingEntity living) {
        this.rangeAttack(living.m_20183_(), this.getDamage(), this.getRange());
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * 0.67f, this.getRange() * (double)0.67f);
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList;
        double effectRange = range * range;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos pos = this.m_20183_();
            for (int ran = 0; ran < 3; ++ran) {
                for (int i = 0; i < 3; ++i) {
                    this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123745_, 2 + ran * 4, pos, -0.25 + (double)i * 0.5);
                }
            }
        }
        if ((entityList = this.getEntityList(LivingEntity.class, this.isBladTarget(effectRange), range)).isEmpty()) {
            return;
        }
        for (LivingEntity entity : entityList) {
            this.attackDamage(entity, dame, false);
            this.addAttack(entity, dame, this.getAddAttack());
        }
    }

    @Override
    public void despawnAction() {
        if (!this.getArrow()) {
            return;
        }
        this.rangeAttack(this.m_20183_().m_7494_(), this.getDamage(), this.getRange());
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_ / 20.0);
        float y = (float)(-vec.f_82480_ / 20.0);
        float z = (float)(-vec.f_82481_ / 20.0);
        for (int i = 0; i < 6; ++i) {
            float f1 = (float)(this.m_20185_() - 0.5 + (double)this.rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)this.rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)this.rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleTypes.f_123744_, f1, f2, f3, x + this.getRandFloat(0.075f), y + this.getRandFloat(0.075f), z + this.getRandFloat(0.075f));
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.FLAME;
    }
}

