/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class TridentThunder
extends AbstractMagicShot {
    private static final EntityDataAccessor<Boolean> LIGHNING = TridentThunder.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CHARGE = TridentThunder.setEntityData(ISMMob.BOOLEAN);

    public TridentThunder(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public TridentThunder(double x, double y, double z, Level world) {
        this(EntityInit.tridentThunder, world);
        this.m_6034_(x, y, z);
    }

    public TridentThunder(Level world, LivingEntity entity, WandInfo wandInfo) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = wandInfo.getStack();
    }

    public TridentThunder(Level world, LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(LIGHNING, false);
        this.define(CHARGE, false);
    }

    public boolean getLighning() {
        return this.get(LIGHNING);
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    public boolean getCharge() {
        return this.get(CHARGE);
    }

    @Override
    public void m_8119_() {
        if (this.getCharge()) {
            return;
        }
        super.m_8119_();
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (!this.getLighning()) {
            this.set(LIGHNING, true);
            this.setMaxLifeTime(10);
            this.rangeAttack(this.getDamage() * 0.5f, this.getRange());
            this.m_5496_(SoundEvents.f_12090_, 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_12089_, 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_12515_, 1.0f, 1.0f);
        }
    }

    public void rangeAttack(float dame, double range) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> !(e instanceof ISMMob), range);
        if (entityList.isEmpty()) {
            return;
        }
        for (LivingEntity entity : entityList) {
            this.attackDamage(entity, dame, false);
            this.addPotion(entity, PotionInit.lightning_wind_vulnerable, 1200, 1);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.LIGHTNING;
    }
}

