/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.fluid;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterCupWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private static final int MAX_VALUE = 250;
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    protected ItemStack stack;

    public WaterCupWrapper(ItemStack stack) {
        this.stack = stack;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.stack;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid.getFluid() == Fluids.f_76193_ || fluid.getFluid() == Fluids.f_76195_) {
            return true;
        }
        return !fluid.getFluid().getFluidType().getBucket(fluid).m_41619_();
    }

    @NotNull
    public FluidStack getFluid() {
        return new FluidStack((Fluid)Fluids.f_76193_, 250);
    }

    protected void setFluid(@NotNull FluidStack fluidStack) {
        this.stack = FluidUtil.getFilledBucket((FluidStack)fluidStack);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 250;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.stack.m_41613_() != 1 || resource.getAmount() < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.getFluid();
        if (!fluid.isEmpty() && fluid.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluid;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.stack.m_41613_() != 1 || maxDrain < 250) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.getFluid();
        if (!fluid.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluid;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction face) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, this.holder);
    }
}

