/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.projectile.MagicSquareMagic;
import sweetmagic.init.item.magic.BaseMagicItem;

public class FieldMagic
extends BaseMagicItem {
    public final int data;
    public final int tier;

    public FieldMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.FIELD, ele, tier, coolTime, useMF, false);
        this.data = data;
        this.tier = tier;
    }

    public FieldMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.FIELD, ele, tier, coolTime, useMF, false, iconName);
        this.data = data;
        this.tier = tier;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        switch (this.data) {
            case 0: 
            case 1: 
            case 2: 
            case 13: {
                toolTip.add(this.getText("magic_square_buff", new Object[]{60 + this.tier * 30}).m_130940_(WHITE));
                toolTip.add(this.getText("magic_gravityfield", new Object[]{this.formatPar(10.0f + (float)this.data * 7.5f)}));
                if (this.data == 13) {
                    toolTip.add(this.getText("magic_gravityfield2_enemy"));
                } else {
                    toolTip.add(this.getText(this.name + "_enemy"));
                }
                toolTip.add(this.getText("magic_square").m_130940_(WHITE));
                toolTip.add(this.getText("magic_gravityfield_finish", new Object[]{this.getEffectTip("gravity").getString()}));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                toolTip.add(this.getText("magic_square_buff", new Object[]{60 + this.tier * 30}).m_130940_(WHITE));
                toolTip.add(this.getText("magic_windfield"));
                toolTip.add(this.getText("magic_square").m_130940_(WHITE));
                toolTip.add(this.getText("magic_windfield_regene"));
                toolTip.add(this.getText("magic_windfield_finish", new Object[]{this.getEffectTip("bleeding").getString()}));
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                toolTip.add(this.getText("magic_square_buff", new Object[]{60 + this.tier * 30}).m_130940_(WHITE));
                int value = this.data - (this.data == 15 ? 11 : 5);
                toolTip.add(this.getText("magic_rainfield", new Object[]{value}));
                toolTip.add(this.getText("magic_rainfield_enemy", new Object[]{value}));
                toolTip.add(this.getText("magic_square").m_130940_(WHITE));
                toolTip.add(this.getText("magic_rainfield_finish", new Object[]{Float.valueOf(12.5f * (float)this.tier)}));
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                toolTip.add(this.getText("magic_square").m_130940_(WHITE));
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText("magic_future_visionfiled_enemy", new Object[]{String.format("%.1f", Float.valueOf(2.0f + (float)(this.data == 16 ? 3 : this.data - 9) * 1.5f))}));
                toolTip.add(this.getText("magic_future_visionfiled_finish", new Object[]{this.tier}));
                break;
            }
            case 12: {
                toolTip.add(this.getText("magic_square_buff", new Object[]{60 + this.tier * 30}).m_130940_(WHITE));
                toolTip.add(this.getText(this.name + "_enemy"));
                toolTip.add(this.getText("magic_square").m_130940_(WHITE));
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText(this.name + "_finish"));
                break;
            }
            default: {
                toolTip.add(this.getText(this.name));
            }
        }
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        BlockPos pos = player.m_20183_();
        MagicSquareMagic entity = new MagicSquareMagic(world, (LivingEntity)player, wandInfo);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 0.0f);
        entity.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        entity.setHitDead(false);
        entity.setNotDamage(true);
        entity.setData(this.data);
        int level = wandInfo.getWandLevel();
        entity.setRange(Math.min(3.0 + (double)level * 0.5, 12.0));
        entity.setMaxLifeTime(600 + level * 20);
        switch (this.data) {
            case 0: {
                entity.setData(0);
                entity.setTier(1);
                break;
            }
            case 1: {
                entity.setData(0);
                entity.setTier(2);
                break;
            }
            case 2: {
                entity.setData(0);
                entity.setTier(3);
                break;
            }
            case 3: {
                entity.setData(1);
                entity.setTier(1);
                break;
            }
            case 4: {
                entity.setData(1);
                entity.setTier(2);
                break;
            }
            case 5: {
                entity.setData(1);
                entity.setTier(3);
                break;
            }
            case 6: {
                entity.setData(2);
                entity.setTier(1);
                break;
            }
            case 7: {
                entity.setData(2);
                entity.setTier(2);
                break;
            }
            case 8: {
                entity.setData(2);
                entity.setTier(3);
                break;
            }
            case 9: {
                entity.setData(3);
                entity.setTier(1);
                break;
            }
            case 10: {
                entity.setData(3);
                entity.setTier(2);
                break;
            }
            case 11: {
                entity.setData(3);
                entity.setTier(3);
                break;
            }
            case 12: {
                entity.setData(4);
                entity.setTier(4);
                break;
            }
            case 13: {
                entity.setData(0);
                entity.setTier(4);
                break;
            }
            case 14: {
                entity.setData(1);
                entity.setTier(4);
                break;
            }
            case 15: {
                entity.setData(2);
                entity.setTier(4);
                break;
            }
            case 16: {
                entity.setData(3);
                entity.setTier(4);
            }
        }
        entity.acceEffect(wandInfo);
        if (!world.m_5776_()) {
            world.m_7967_((Entity)entity);
        }
        this.playSound(world, player.m_20183_(), SoundInit.FLASH, 0.25f, 1.0f);
        return true;
    }
}

