/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.item.magic.BaseMagicItem;
import sweetmagic.init.tile.menu.container.BaseContainer;

public class MFTeleport
extends BaseMagicItem {
    public MFTeleport(String name, boolean isShrink) {
        super(name, SMMagicType.CHARGE, SMElement.TIME, 1, 40, isShrink ? 10 : 100, isShrink);
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        toolTip.add(this.getText(this.name));
        return toolTip;
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("pX");
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        ItemStack stack = wandInfo.getStack();
        IWand wand = wandInfo.getWand();
        ItemStack slotStack = wand.getSlotItem(player, new WandInfo(stack));
        CompoundTag tags = slotStack.m_41783_();
        if (tags != null && tags.m_128441_("pX")) {
            this.teleportTo(player, player.m_20183_(), slotStack, tags);
        }
        return true;
    }

    public void teleportTo(Player player, BlockPos basePos, ItemStack stack, CompoundTag tags) {
        Level world = player.m_9236_();
        this.playSound(world, player.m_20183_(), SoundEvents.f_11852_, 0.25f, 1.0f);
        BlockPos pos = new BlockPos((double)((float)tags.m_128451_("pX") + 0.5f), (double)((float)tags.m_128451_("pY") + 1.0f), (double)((float)tags.m_128451_("pZ") + 0.5f));
        ResourceLocation dim = new ResourceLocation(tags.m_128461_("dim"));
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            double range = 0.875;
            double ySpeed = -2.0;
            for (int i = -1; i < 5; ++i) {
                this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123760_, range, basePos.m_6630_(1), (double)i / 3.0, ySpeed, 1.0);
            }
        }
        if (player.m_20194_() != null && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ServerLevel server = sp.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dim));
            sp.m_8999_(server, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            this.playSound((Level)server, pos, SoundEvents.f_11852_, 0.25f, 1.0f);
            double range = 0.875;
            double ySpeed = 1.0;
            for (int i = -1; i < 5; ++i) {
                this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123760_, range, pos.m_6625_(2), (double)i / 3.0, 1.0, 1.0);
            }
        }
        player.f_19789_ = 0.0f;
        player.m_6756_(0);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tags = stack.m_41784_();
        if (tags != null && player.m_6144_() && !world.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BaseContainer.ContainerClero(stack));
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!world.m_5776_()) {
            BlockPos pos = player.m_20183_();
            tags.m_128405_("pX", pos.m_123341_());
            tags.m_128405_("pY", pos.m_123342_());
            tags.m_128405_("pZ", pos.m_123343_());
            tags.m_128359_("dim", world.m_46472_().m_135782_().toString());
            tags.m_128359_("dim_view", world.m_46472_().m_135782_().m_135815_().toString());
            player.m_213846_((Component)this.getText("posregi").m_130940_(GREEN));
        }
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11852_, 1.0f, 1.0f);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        toolTip.add((Component)this.getText("clerodendrum").m_130940_(GREEN));
        toolTip.add((Component)this.getText("clero_rename").m_130940_(GOLD));
        toolTip.add((Component)this.empty());
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("pX")) {
            int x = tag.m_128451_("pX");
            int y = tag.m_128451_("pY");
            int z = tag.m_128451_("pZ");
            String dim = tag.m_128461_("dim_view");
            String pos = ": " + x + ", " + y + ", " + z;
            toolTip.add((Component)this.getTipArray(new Object[]{this.getText("regi_pos"), this.getLabel(pos, WHITE)}).m_130940_(GREEN));
            toolTip.add((Component)this.getTipArray(new Object[]{this.getText("regi_dim"), this.getLabel(": " + dim, WHITE)}).m_130940_(GREEN));
        }
    }
}

