/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.item.magic.BaseMagicItem;

public class NormalMagic
extends BaseMagicItem {
    public final int data;

    public NormalMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.NORMAL, ele, tier, coolTime, useMF, false);
        this.data = data;
    }

    public NormalMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.NORMAL, ele, tier, coolTime, useMF, false, iconName);
        this.data = data;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        switch (this.data) {
            case 0: 
            case 1: {
                toolTip.add(this.getText("magic_quickheal.1", new Object[]{String.format("%.0f%%", Float.valueOf(25.0f * (float)(this.data + 1)))}));
                toolTip.add(this.getText("magic_quickheal.2"));
                break;
            }
            case 2: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText(this.name + "_caution"));
                break;
            }
            case 10: {
                toolTip.add(this.getText("magic_quickheal.1", new Object[]{String.format("%.0f%%", Float.valueOf(100.0f))}));
                break;
            }
            case 11: {
                toolTip.add(this.getText("magic_reflasheffect"));
                toolTip.add(this.getText(this.name));
                break;
            }
            case 12: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText(this.name + "_regene"));
                break;
            }
            case 14: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText("magic_aether_shield_wand"));
                break;
            }
            case 15: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText(this.name + "_recast"));
                toolTip.add(this.getText("magic_aether_shield_wand"));
                break;
            }
            case 16: {
                String buf = this.getMCTip("absorption").getString() + this.getEnchaTip(4).getString();
                toolTip.add(this.getText("magic_quickheal.2", new Object[]{String.format("%.0f%%", Float.valueOf(100.0f)), buf}));
                toolTip.add(this.getText("magic_reflasheffect"));
                break;
            }
            case 17: {
                String barrier = this.getMCTip("absorption").getString();
                String regeneration = this.getEffectTip("regeneration").getString();
                toolTip.add(this.getText(this.name, new Object[]{barrier, regeneration}));
                break;
            }
            case 18: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText("magic_aether_shield2_recast"));
                toolTip.add(this.getText("magic_aether_shield_wand"));
                break;
            }
            default: {
                toolTip.add(this.getText(this.name));
            }
        }
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wInfo, MagicInfo mInfo) {
        ItemStack stack = wInfo.getStack();
        this.acceEffect(player, Float.valueOf(this.getPower(wInfo)));
        return switch (this.data) {
            case 1 -> this.healAction(world, player, stack, wInfo);
            case 2 -> this.armorAction(world, player, stack, wInfo);
            case 3 -> this.barrierAction(world, player, stack, wInfo);
            case 4 -> this.reflashEffectAction(world, player, stack, wInfo);
            case 5 -> this.reflashEffectAction(world, player, stack, wInfo);
            case 6 -> this.potionAction(world, player, stack, wInfo);
            case 7 -> this.potionAction(world, player, stack, wInfo);
            case 8 -> this.potionAction(world, player, stack, wInfo);
            case 9 -> this.potionAction(world, player, stack, wInfo);
            case 10 -> this.healAction(world, player, stack, wInfo);
            case 11 -> this.reflashEffectAction(world, player, stack, wInfo);
            case 12 -> this.barrierAction(world, player, stack, wInfo);
            case 13 -> this.invisibleAction(world, player, stack, wInfo);
            case 14 -> this.aetherShiledAction(world, player, stack, wInfo);
            case 15 -> this.aetherShiledAction(world, player, stack, wInfo);
            case 16 -> this.healAction(world, player, stack, wInfo);
            case 17 -> this.barrierAction(world, player, stack, wInfo);
            case 18 -> this.aetherShiledAction(world, player, stack, wInfo);
            case 19 -> this.potionAction(world, player, stack, wInfo);
            case 20 -> this.barrierOriginAction(world, player, stack, wInfo);
            default -> this.healAction(world, player, stack, wInfo);
        };
    }

    public boolean armorAction(Level world, Player player, ItemStack stack, WandInfo info) {
        int level = (info.getWandLevel() - 1) / 10;
        int time = (int)this.getHealValue(player, 2400 + info.getWandLevel() * 120);
        this.addPotion((LivingEntity)player, PotionInit.aether_armor, level, time);
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11887_, 0.5f, 1.175f);
        return true;
    }

    public boolean barrierAction(Level world, Player player, ItemStack stack, WandInfo info) {
        int level = info.getWandLevel();
        int time = (int)this.getHealValue(player, this.effectTime(info));
        if (this.data == 17) {
            double range = 7.5 * (1.0 + (double)this.getExtensionRingCount(player) * 0.25);
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (Entity)player, e -> e.m_6084_() && !(e instanceof Enemy), range);
            for (LivingEntity entity : entityList) {
                this.addPotion(entity, PotionInit.regeneration, 0, time);
                this.addPotion(entity, PotionInit.aether_barrier, level, time);
                entity.m_21195_(PotionInit.aether_barrier_origin);
                this.playSound(world, entity, SoundEvents.f_11887_, 0.5f, 1.175f);
            }
        } else {
            if (this.data == 12) {
                this.addPotion((LivingEntity)player, PotionInit.regeneration, 0, time);
                time = (int)((float)time * 1.25f);
            }
            this.addPotion((LivingEntity)player, PotionInit.aether_barrier, level, time);
            player.m_21195_(PotionInit.aether_barrier_origin);
            this.playSound(world, (LivingEntity)player, SoundEvents.f_11887_, 0.5f, 1.175f);
        }
        return true;
    }

    public boolean reflashEffectAction(Level world, Player player, ItemStack stack, WandInfo info) {
        boolean isTier3;
        int time = this.data == 4 ? 2 : (int)this.getHealValue(player, this.effectTime(info));
        double range = 7.5 * (1.0 + (double)this.getExtensionRingCount(player) * 0.25);
        boolean bl = isTier3 = this.data == 11;
        if (isTier3) {
            range *= 1.25;
        }
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            for (int i = 0; i < 20; ++i) {
                this.spawnParticleCycle(server, (ParticleOptions)ParticleInit.CYCLE_REFLASH, x, y + 0.25, z, Direction.UP, range, i * 18, false);
            }
        }
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (Entity)player, e -> e.m_6084_() && !(e instanceof Enemy), range);
        for (LivingEntity entity : entityList) {
            this.addPotion(entity, PotionInit.reflash_effect, 0, time);
            if (isTier3) {
                this.addPotion(entity, PotionInit.resurrection, 0, time);
            }
            double pX = entity.m_20185_();
            double pY = entity.m_20186_();
            double pZ = entity.m_20189_();
            for (int i = 0; i < 3; ++i) {
                this.spawnParticleRing(world, (ParticleOptions)ParticleInit.REFLASH, 1.0, pX, pY, pZ, 0.5 + (double)i * 0.5, 0.025, 1.0);
            }
        }
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11887_, 0.5f, 1.175f);
        return true;
    }

    public boolean potionAction(Level world, Player player, ItemStack stack, WandInfo info) {
        int time = (int)this.getHealValue(player, this.effectTime(info));
        MobEffect effect = null;
        switch (this.data) {
            case 6: {
                effect = MobEffects.f_19608_;
                break;
            }
            case 7: {
                effect = MobEffects.f_19611_;
                break;
            }
            case 8: {
                effect = MobEffects.f_19596_;
                break;
            }
            case 9: {
                effect = MobEffects.f_19600_;
                break;
            }
            case 19: {
                effect = MobEffects.f_19605_;
            }
        }
        this.addPotion((LivingEntity)player, effect, 1, this.data == 19 ? time / 10 : time);
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11772_, 0.5f, 1.175f);
        return true;
    }

    public boolean healAction(Level world, Player player, ItemStack stack, WandInfo info) {
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        double range = 2.5 * (double)this.getTier() * (1.0 + (double)this.getExtensionRingCount(player) * 0.25);
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (Entity)player, e -> e.m_6084_() && !(e instanceof Enemy), range);
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            for (int i = 0; i < 20; ++i) {
                this.spawnParticleCycle(server, (ParticleOptions)ParticleInit.CYCLE_HEAL, x, y + 0.25, z, Direction.UP, range, i * 18, false);
            }
        }
        float healRate = 1.0f;
        int level = info.getWandLevel();
        int time = (int)this.getHealValue(player, this.effectTime(info));
        switch (this.data) {
            case 0: {
                healRate = 0.25f + (float)level * 0.01f;
                break;
            }
            case 1: {
                healRate = 0.5f + (float)level * 0.01f;
            }
        }
        for (LivingEntity entity : entityList) {
            entity.m_5634_(entity.m_21233_() * healRate);
            entity.m_21195_(MobEffects.f_19612_);
            entity.m_21195_(MobEffects.f_19613_);
            if (entity instanceof Player) {
                this.playSound(world, entity, SoundInit.HEAL, 0.0625f, 1.0f);
            }
            double pX = entity.m_20185_();
            double pY = entity.m_20186_();
            double pZ = entity.m_20189_();
            if (this.data == 16) {
                this.addPotion(entity, MobEffects.f_19617_, 3, time);
                this.addPotion(entity, PotionInit.resurrection, 0, time);
                this.addPotion(entity, PotionInit.reflash_effect, 0, time);
            }
            for (int i = 0; i < 3; ++i) {
                this.spawnParticleRing(world, (ParticleOptions)ParticleTypes.f_123748_, 1.0, pX, pY, pZ, 0.75 + (double)i * 0.5, 1.0, 1.0);
            }
        }
        return true;
    }

    public boolean invisibleAction(Level world, Player player, ItemStack stack, WandInfo info) {
        int time = (int)this.getHealValue(player, this.effectTime(info));
        this.addPotion((LivingEntity)player, MobEffects.f_19609_, 0, time);
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11887_, 0.5f, 1.175f);
        List<Mob> entityList = this.getEntityList(Mob.class, (Entity)player, e -> e.m_6084_() && e.m_5448_() != null && e.m_5448_().m_20148_() == player.m_20148_(), 64.0);
        entityList.forEach(e -> e.m_6710_(null));
        return true;
    }

    public boolean aetherShiledAction(Level world, Player player, ItemStack stack, WandInfo info) {
        int timeValue = 300;
        switch (this.data) {
            case 15: {
                timeValue = 500;
                break;
            }
            case 18: {
                timeValue = 800;
            }
        }
        int level = 0;
        switch (this.data) {
            case 15: {
                level = 1;
                break;
            }
            case 18: {
                level = 2;
            }
        }
        int time = (int)this.getHealValue(player, timeValue);
        this.addPotion((LivingEntity)player, PotionInit.aether_shield, level, time);
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11887_, 0.5f, 1.175f);
        if (!info.getWand().isCreativeWand()) {
            player.m_36335_().m_41524_(stack.m_41720_(), 200);
        }
        List<Mob> entityList = this.getEntityList(Mob.class, (Entity)player, e -> e.m_6084_() && e instanceof Enemy, 64.0);
        entityList.forEach(e -> e.m_6710_((LivingEntity)player));
        return true;
    }

    public boolean barrierOriginAction(Level world, Player player, ItemStack stack, WandInfo info) {
        int level = info.getWandLevel();
        int time = (int)this.getHealValue(player, this.effectTime(info));
        this.addPotion((LivingEntity)player, PotionInit.aether_barrier_origin, level, time);
        player.m_21195_(PotionInit.aether_barrier);
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11887_, 0.5f, 1.175f);
        return true;
    }

    @Override
    public boolean isUniqueMagic() {
        return this.data == 20;
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        if (this.data != 20) {
            return;
        }
        toolTip.add((Component)this.getText("magic_aether_barrier_origin_get").m_130940_(RED));
    }
}

