/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.DistExecutor;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.emagic.SMAcceType;
import sweetmagic.api.emagic.SMDropType;
import sweetmagic.api.iitem.IAcce;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.info.AcceInfo;
import sweetmagic.api.iitem.info.PorchInfo;
import sweetmagic.event.KeyPressEvent;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.init.potion.SMEffect;
import sweetmagic.init.tile.inventory.SMInventory;
import sweetmagic.key.SMKeybind;
import sweetmagic.util.ItemHelper;
import sweetmagic.util.SMUtil;

public class SMAcce
extends SMItem
implements IAcce {
    private final String name;
    private final int data;
    private final int tier;
    private SMAcceType accType;
    private SMDropType dropType;
    public static final String NOT_ACTIVE = "notActive";
    public static final UUID BLOCK_REACH = UUID.fromString("c85e7079-e9f1-40e8-970e-bf327c23251a");
    private static final UUID ATTACK_SPEED = UUID.fromString("0A87A51E-A43F-4EEF-A770-07C2160D373D");
    private int tickTime = 0;

    public SMAcce(String name, int data, int tier, SMAcceType accType, SMDropType dropType) {
        super(name, new Item.Properties().m_41491_(SweetMagicCore.smMagicTab).m_41487_(1));
        this.name = name;
        this.data = data;
        this.tier = tier;
        this.setAcceType(accType);
        this.setDropType(dropType);
    }

    @Override
    public void magicToolTip(List<MutableComponent> toolTip, ItemStack stack) {
        int count = this.getStackCount(new AcceInfo(stack));
        String name = this.name;
        switch (this.data) {
            case 0: {
                toolTip.add(this.getText(name, new Object[]{count * 2}));
                toolTip.add(this.getText(name + "_buff"));
                break;
            }
            case 1: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_quick"));
                break;
            }
            case 2: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_time", new Object[]{this.getEffectTip("flame"), this.formatParZero(10.0f * (float)count)}));
                break;
            }
            case 3: {
                toolTip.add(this.getText(name, new Object[]{this.formatParZero(50.0f * (float)count)}));
                break;
            }
            case 4: {
                toolTip.add(this.getText(name + "_dame", new Object[]{this.formatParZero(20.0f * (float)count)}));
                toolTip.add(this.getText(name + "_kill", new Object[]{this.formatParZero(10.0f * (float)count)}));
                toolTip.add(this.getText(name + "_dark"));
                break;
            }
            case 5: {
                toolTip.add(this.getText(name, new Object[]{this.formatParZero(10.0f * (float)count)}));
                toolTip.add(this.getText(name + "_damage", new Object[]{this.formatParZero(1.0f * (float)count)}));
                break;
            }
            case 6: {
                toolTip.add(this.getText(name, new Object[]{this.getEnchaTip(count + 1)}));
                toolTip.add(this.getText(name + "_critical", new Object[]{this.getMCTip("luck")}));
                break;
            }
            case 7: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_damage_suffe", new Object[]{this.formatParZero(10.0f * (float)count)}));
                toolTip.add(this.getText(name + "_damage_inflicte", new Object[]{this.formatParZero(10.0f * (float)count)}));
                break;
            }
            case 8: {
                toolTip.add(this.getText(name, new Object[]{this.formatParZero(50.0f + (float)(count - 1) * 12.5f), this.getEnchaTip(count)}));
                toolTip.add(this.getText(name + "_cooltime", new Object[]{this.format(600.0f - 37.5f * (float)(count - 1))}));
                break;
            }
            case 9: {
                toolTip.add(this.getText(name, new Object[]{String.format("%.2f%%", Float.valueOf(6.25f * (float)count))}));
                toolTip.add(this.getText(name + "_exp", new Object[]{this.formatPar(12.5f * (float)count)}));
                toolTip.add(this.getText(name + "_magic"));
                break;
            }
            case 10: {
                toolTip.add(this.getText(name, new Object[]{this.getEffectTip("aether_armor")}));
                toolTip.add(this.getText(name + "_charge"));
                toolTip.add(this.getText(name + "_boss"));
                break;
            }
            case 11: {
                MutableComponent key = KeyPressEvent.getKeyName(SMKeybind.POUCH);
                toolTip.add(this.getText(name, new Object[]{6 + count * 2}));
                toolTip.add(this.getTipArray(new Object[]{"[", key.m_6881_(), this.getText("key_no"), "]", this.getText(name + "_off")}));
                break;
            }
            case 12: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_counter"));
                toolTip.add(this.getText(name + "_cool"));
                break;
            }
            case 13: {
                toolTip.add(this.getText(name, new Object[]{this.formatParZero(25.0f * (float)count)}));
                toolTip.add(this.getText(name + "_debuff", new Object[]{this.formatPar(12.5f * (float)count)}));
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_up"));
                break;
            }
            case 16: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_attack"));
                toolTip.add(this.getText(name + "_add"));
                break;
            }
            case 18: {
                toolTip.add(this.getText(name));
                String heal = this.getEffectTip("regeneration").getString();
                String dame = this.getMCTip("strength").getString() + this.getEnchaTip(4).getString();
                String mf = this.getEffectTip("mfcostdown").getString() + this.getEnchaTip(3).getString();
                toolTip.add(this.getText(name + "_buff", new Object[]{heal, dame, mf}));
                toolTip.add(this.getText(name + "_heal"));
                break;
            }
            case 19: {
                toolTip.add(this.getText(name, new Object[]{this.formatParZero(20.0f * (float)count)}));
                break;
            }
            case 20: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText("varrier_pendant_cooltime", new Object[]{this.format(600.0f - 37.5f * (float)(count - 1))}));
                break;
            }
            case 21: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_ele"));
                break;
            }
            case 22: {
                toolTip.add(this.getText(name, new Object[]{this.formatParZero(30.0f * (float)count)}));
                break;
            }
            case 23: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_debuff"));
                toolTip.add(this.getText(name + "_xp"));
                toolTip.add(this.getText(name + "_chance"));
                break;
            }
            case 24: {
                toolTip.add(this.getText(name, new Object[]{this.formatPar(12.5f * (float)count)}));
                toolTip.add(this.getText(name + "_single", new Object[]{count}));
                break;
            }
            case 25: {
                toolTip.add(this.getText(name));
                MutableComponent key2 = KeyPressEvent.getKeyName(SMKeybind.NEXT);
                toolTip.add(this.getTipArray(new Object[]{"[", key2.m_6881_(), this.getText("key_no"), "]", this.getText("gravity_pendant_off")}));
                toolTip.add(this.getText(name + "_dig", new Object[]{this.formatParZero(20.0f * (float)count)}));
                break;
            }
            case 26: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_critical1"));
                toolTip.add(this.getText(name + "_critical2"));
                break;
            }
            case 27: {
                toolTip.add(this.getText("wizard_brooch"));
                toolTip.add(this.getText(name));
                break;
            }
            case 28: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_twi"));
                toolTip.add(this.getText(name + "_summon", new Object[]{this.formatPar(25.0f)}));
                break;
            }
            case 29: {
                toolTip.add(this.getText(name, new Object[]{this.getMCTip("strength")}));
                toolTip.add(this.getText(name + "_attack", new Object[]{this.getEffectTip("flame")}));
                break;
            }
            case 30: {
                toolTip.add(this.getText(name, new Object[]{2 * count}));
                break;
            }
            case 31: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_0"));
                toolTip.add(this.getText(name + "_1"));
                break;
            }
            case 32: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_attack"));
                break;
            }
            case 33: {
                toolTip.add(this.getText(name, new Object[]{this.formatPar((float)count * 5.0f)}));
                toolTip.add(this.getText(name + "_armor", new Object[]{this.formatPar((float)count * 10.0f)}));
                break;
            }
            case 34: {
                toolTip.add(this.getText("wizard_brooch"));
                toolTip.add(this.getText(name, new Object[]{this.formatPar((float)count * 5.0f)}));
                break;
            }
            case 36: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_fall1"));
                toolTip.add(this.getText(name + "_fall2"));
                break;
            }
            case 37: {
                String tip = this.getEffectTip("flame").getString();
                toolTip.add(this.getText(name, new Object[]{tip}));
                toolTip.add(this.getText(name + "_attack", new Object[]{tip}));
                break;
            }
            case 38: {
                toolTip.add(this.getText(name));
                toolTip.add(this.getText(name + "_add"));
                break;
            }
            default: {
                toolTip.add(this.getText(name));
            }
        }
    }

    @Override
    public void debuffRemovalTip(List<MutableComponent> toolTip) {
        switch (this.data) {
            case 2: {
                toolTip.add(this.getEffectTip("flame"));
                break;
            }
            case 3: {
                toolTip.add(this.getEffectTip("bubble"));
                break;
            }
            case 6: {
                toolTip.add(this.getMCTip("unluck"));
                break;
            }
            case 11: {
                toolTip.add(this.getEffectTip("gravity"));
                break;
            }
            case 22: {
                toolTip.add(this.getMCTip("slowness"));
            }
        }
    }

    @Override
    public void dropMobTip(List<MutableComponent> toolTip) {
        String text;
        switch (this.data) {
            case 10: {
                String string = "witch_sandryon";
                break;
            }
            case 12: {
                String string = "silver_landroad";
                break;
            }
            case 14: {
                String string = "ignisknight";
                break;
            }
            case 15: {
                String string = "queenfrost";
                break;
            }
            case 16: {
                String string = "holyangel";
                break;
            }
            case 18: {
                String string = "elsharia_curious";
                break;
            }
            case 21: {
                String string = "blitz_wizard_master";
                break;
            }
            case 26: {
                String string = "ancientfairy";
                break;
            }
            case 27: {
                String string = "arlaune";
                break;
            }
            case 28: {
                String string = "twilight_hora";
                break;
            }
            case 29: {
                String string = "brave_skeleton";
                break;
            }
            case 31: {
                String string = "stella_wizard_master";
                break;
            }
            case 32: {
                String string = "demons_belial";
                break;
            }
            case 37: {
                String string = "bullfight";
                break;
            }
            case 38: {
                String string = "gemfrog";
                break;
            }
            default: {
                String string = text = "";
            }
        }
        if (text.isEmpty()) {
            return;
        }
        toolTip.add(this.getEntityTip(text));
    }

    @Override
    public int getMaxStackCount() {
        return switch (this.data) {
            case 0 -> 5;
            case 2 -> 5;
            case 3 -> 6;
            case 4 -> 5;
            case 5 -> 10;
            case 6 -> 4;
            case 7 -> 5;
            case 8 -> 5;
            case 9 -> 8;
            case 11 -> 4;
            case 13 -> 4;
            case 19 -> 5;
            case 20 -> 4;
            case 22 -> 5;
            case 24 -> 8;
            case 25 -> 5;
            case 30 -> 5;
            case 33 -> 5;
            case 34 -> 5;
            default -> 1;
        };
    }

    @Override
    public boolean canUseEffect(Level world, Player player, AcceInfo info) {
        boolean flag;
        ++this.tickTime;
        boolean hasCoolTime = !player.m_36335_().m_41519_(info.getItem());
        switch (this.data) {
            case 4: {
                boolean bl;
                if (player.m_21223_() > 1.0f) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: {
                boolean bl;
                if (player.m_21223_() <= player.m_21233_() * 0.3f) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 11: {
                boolean bl;
                if (!info.getNBT().m_128471_(NOT_ACTIVE)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 20: {
                boolean bl;
                if (player.f_19797_ % 30 != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 23: {
                boolean bl;
                if (this.tickTime % 10 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 25: {
                boolean bl;
                if (!info.getNBT().m_128471_(NOT_ACTIVE)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = flag = true;
            }
        }
        if (this.tickTime % 20 == 0) {
            this.tickTime = 0;
        }
        return hasCoolTime && flag;
    }

    @Override
    public void onUpdate(Level world, Player player, AcceInfo info) {
        ItemStack stack = info.getStack();
        switch (this.data) {
            case 0: {
                this.checkDebuf(player, MobEffects.f_19612_, MobEffects.f_19613_);
            }
            case 2: {
                this.scorchEffect(world, player, stack);
                break;
            }
            case 23: {
                this.forkEffext(world, player, stack);
                break;
            }
            case 36: {
                this.parasolEffext(world, player, stack);
            }
        }
    }

    @Override
    public void onClientUpdate(Level world, Player player, AcceInfo info) {
        ItemStack stack = info.getStack();
        switch (this.data) {
            case 36: {
                this.parasolEffext(world, player, stack);
            }
        }
    }

    @Override
    public void onMultiUpdate(Level world, Player player, AcceInfo info, PorchInfo pInfo) {
        ItemStack leg = pInfo.getStack();
        IPorch porch = pInfo.getPorch();
        int count = porch.acceCount(leg, this, this.getMaxStackCount());
        switch (this.data) {
            case 6: {
                this.addPotion((LivingEntity)player, MobEffects.f_19621_, count, 201);
                this.checkDebuf(player, MobEffects.f_19590_);
                break;
            }
            case 7: {
                this.checkDebuf(player, MobEffects.f_19610_);
                break;
            }
            case 8: {
                this.varrierEffect(world, player, info, count);
                break;
            }
            case 11: {
                this.gravityEffext(world, player, count);
                break;
            }
            case 20: {
                this.electricEffect(world, player, info, count);
            }
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeMap(Level world, Player player, AcceInfo info, PorchInfo pInfo) {
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        ItemStack leg = pInfo.getStack();
        IPorch porch = pInfo.getPorch();
        int count = porch.acceCount(leg, this, this.getMaxStackCount());
        switch (this.data) {
            case 3: {
                map.putAll(this.mermaidEffect(world, player, info, count));
                break;
            }
            case 22: {
                map.putAll(this.featherEffect(world, player, info, count));
                break;
            }
            case 30: {
                map.putAll(this.bandEffect(world, player, info, count));
            }
        }
        return map.build();
    }

    public boolean scorchEffect(Level world, Player player, ItemStack stack) {
        this.addPotion((LivingEntity)player, MobEffects.f_19607_, 0, 201);
        if (player.m_6060_()) {
            player.m_20095_();
        }
        this.checkDebuf(player, PotionInit.flame);
        return true;
    }

    public boolean gravityEffext(Level world, Player player, int count) {
        this.checkDebuf(player, PotionInit.gravity);
        List<ItemEntity> entityList = this.getEntityList(ItemEntity.class, (Entity)player, 6.0 + (double)count * 2.0);
        NonNullList pInv = player.m_150109_().f_35974_;
        double x = player.m_20185_();
        double y = player.m_20186_();
        double z = player.m_20189_();
        for (ItemEntity entity : entityList) {
            double dZ;
            double dY;
            ItemStack st = entity.m_32055_();
            if (ItemHelper.simulateFit((NonNullList<ItemStack>)pInv, st) >= st.m_41613_()) continue;
            double dX = x - entity.m_20185_();
            double dist = Math.sqrt(dX * dX + (dY = y - entity.m_20186_()) * dY + (dZ = z - entity.m_20189_()) * dZ);
            double vel = 1.0 - dist / 15.0;
            if (vel > 0.0) {
                vel *= vel;
                entity.m_20256_(entity.m_20184_().m_82520_(dX / dist * vel * 0.1, dY / dist * vel * 0.2, dZ / dist * vel * 0.1));
            }
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel server = (ServerLevel)world;
            float randX = this.getRandFloat(1.5f);
            float randY = this.getRandFloat(1.5f);
            float randZ = this.getRandFloat(1.5f);
            Vec3 vec = entity.m_20184_();
            float f1 = (float)entity.f_19854_ - 0.0f + randX + (float)vec.f_82479_ * 1.5f;
            float f2 = (float)entity.f_19855_ + randY + (float)vec.f_82480_ * 1.5f;
            float f3 = (float)entity.f_19856_ - 0.0f + randZ + (float)vec.f_82481_ * 1.5f;
            float xSpeed = -randX * 0.125f;
            float ySpeed = -randY * 0.125f;
            float zSpeed = -randZ * 0.125f;
            server.m_8767_((ParticleOptions)ParticleInit.NORMAL, (double)f1, (double)f2, (double)f3, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
        }
        int sumXP = 0;
        List<ExperienceOrb> expList = this.getEntityList(ExperienceOrb.class, (Entity)player, e -> !e.getPersistentData().m_128471_("isSum"), 8.0);
        for (ExperienceOrb entity : expList) {
            sumXP += entity.m_20801_();
            entity.m_146870_();
        }
        if (sumXP > 0 && !world.m_5776_()) {
            ExperienceOrb entity = new ExperienceOrb(world, x, y, z, sumXP);
            CompoundTag tag = entity.getPersistentData();
            tag.m_128379_("isSum", true);
            entity.m_7380_(tag);
            world.m_7967_((Entity)entity);
        }
        return true;
    }

    public boolean forkEffext(Level world, Player player, ItemStack stack) {
        int foodLevel = player.m_36324_().m_38702_();
        if (foodLevel >= 20) {
            this.addPotion((LivingEntity)player, MobEffects.f_19606_, 1, 211);
        } else if (6 >= foodLevel) {
            this.addPotion((LivingEntity)player, MobEffects.f_19613_, 1, 211);
        }
        return true;
    }

    public boolean parasolEffext(Level world, Player player, ItemStack stack) {
        player.f_19789_ = 0.0f;
        if (player.m_150110_().f_35935_ || !world.f_46443_) {
            return false;
        }
        if (this.isJumpPressed()) {
            double jumpPower = 0.0515;
            player.m_20256_(player.m_20184_().m_82520_(0.0, jumpPower, 0.0));
        }
        Vec3 vec = player.m_20184_();
        double vX = vec.f_82479_;
        double vY = vec.f_82480_;
        double vZ = vec.f_82481_;
        if (vY < 0.0 && !player.m_20096_()) {
            vY *= player.m_6144_() ? 0.95 : 0.65;
        }
        if ((double)player.f_20902_ > 0.0) {
            if (vec.m_165924_() < 0.8) {
                double bustSpeed = 1.1;
                vX = Math.min(vX * bustSpeed, 0.9);
                vZ = Math.min(vZ * bustSpeed, 0.9);
            }
        } else {
            vX *= 0.9;
            vZ *= 0.9;
        }
        player.m_20256_(new Vec3(vX, vY, vZ));
        return true;
    }

    public boolean varrierEffect(Level world, Player player, AcceInfo info, int count) {
        int value = count - 1;
        player.m_5634_(player.m_21233_() * (0.5f + (float)value * 0.125f));
        this.addPotion((LivingEntity)player, MobEffects.f_19617_, value, 1200);
        this.addPotion((LivingEntity)player, MobEffects.f_19606_, 4, 600);
        player.m_36335_().m_41524_(info.getStack().m_41720_(), 12000 - value * 1000);
        this.playSound((Entity)player, SoundInit.HEAL, 0.0625f, 1.15f);
        return true;
    }

    public boolean electricEffect(Level world, Player player, AcceInfo info, int count) {
        List<Mob> entityList = this.getEntityList(Mob.class, (Entity)player, e -> e instanceof Enemy, 7.5);
        if (entityList.isEmpty()) {
            return false;
        }
        entityList.forEach(e -> SMUtil.tameAIDonmov(e, 60));
        int value = count - 1;
        player.m_36335_().m_41524_(info.getStack().m_41720_(), 12000 - value * 1000);
        this.playSound((Entity)player, SoundInit.ELECTRIC, 0.0625f, 1.15f);
        return true;
    }

    public Multimap<Attribute, AttributeModifier> mermaidEffect(Level world, Player player, AcceInfo info, int count) {
        if (player.m_20069_()) {
            player.m_20301_(player.m_6062_());
            player.f_19789_ = 0.0f;
        }
        this.checkDebuf(player, PotionInit.bubble);
        double range = 0.5 * (double)count;
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        map.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(ATTACK_SPEED, "Attack Speed", range, AttributeModifier.Operation.ADDITION));
        return map.build();
    }

    public Multimap<Attribute, AttributeModifier> featherEffect(Level world, Player player, AcceInfo info, int count) {
        this.checkDebuf(player, MobEffects.f_19597_);
        double range = 0.03 * (double)count;
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        map.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(SMEffect.SPEED_UUID, "Move Speed", range, AttributeModifier.Operation.ADDITION));
        return map.build();
    }

    public Multimap<Attribute, AttributeModifier> bandEffect(Level world, Player player, AcceInfo info, int count) {
        double range = 2.0 * (double)count;
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        map.put((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(BLOCK_REACH, "Block Reach", range, AttributeModifier.Operation.ADDITION));
        return map.build();
    }

    public void checkDebuf(Player player, MobEffect ... potionArray) {
        for (MobEffect potion : potionArray) {
            if (!player.m_21023_(potion)) continue;
            player.m_21195_(potion);
        }
    }

    @Override
    public SMAcceType getAcceType() {
        return this.accType;
    }

    @Override
    public void setAcceType(SMAcceType type) {
        this.accType = type;
    }

    @Override
    public SMDropType getDropType() {
        return this.dropType;
    }

    @Override
    public void setDropType(SMDropType type) {
        this.dropType = type;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean isDuplication() {
        return this.getMaxStackCount() > 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack armor = player.m_6844_(EquipmentSlot.LEGS);
        Item item = armor.m_41720_();
        if (!(item instanceof IPorch)) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        IPorch porch = (IPorch)item;
        SMInventory.SMPorchInventory inv = new SMInventory.SMPorchInventory(new PorchInfo(armor));
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack acce = inv.getStackInSlot(i);
            if (!acce.m_41619_()) continue;
            inv.insertItem(i, stack.m_41777_(), false);
            stack.m_41774_(1);
            this.playSound(world, (LivingEntity)player, SoundInit.ROBE, 0.1f, 1.0f);
            break;
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public boolean isSwitch() {
        return this.data == 11;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.isDuplication() && this.getStackCount(new AcceInfo(stack)) >= this.getMaxStackCount();
    }

    private boolean isJumpPressed() {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().f_91066_.f_92089_.m_90857_(), () -> () -> false);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean main) {
        block3: {
            block2: {
                if (this.data != 36 || !(entity instanceof Player)) break block2;
                Player player = (Player)entity;
                if (!world.m_5776_()) break block3;
            }
            return;
        }
        player.f_19789_ = 0.0f;
    }
}

