/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.block.Broom;
import sweetmagic.init.item.sm.SMItem;

public class SMBroom
extends SMItem
implements IMFTool {
    public int maxMF = 50000;

    public SMBroom(String name) {
        super(name, new Item.Properties().m_41491_(SweetMagicCore.smMagicTab).m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext con) {
        Level world = con.m_43725_();
        Vec3 vec = con.m_43720_();
        Player player = con.m_43723_();
        if (player.m_21023_(PotionInit.non_destructive)) {
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        ItemStack stack = player.m_21205_();
        CompoundTag tags = stack.m_41784_();
        Broom broom = new Broom(world, stack);
        broom.m_146922_(player.m_6144_() ? 0.0f : player.m_146908_());
        broom.m_6034_(vec.f_82479_, vec.f_82480_ + 0.75, vec.f_82481_);
        broom.setMF(this.getMF(stack));
        broom.setNBT(tags);
        broom.setCostDown(this.getEnchantLevel(EnchantInit.mfCostDown, stack));
        broom.setHide(tags.m_128471_("hide"));
        broom.setHover(tags.m_128471_("hover"));
        world.m_7967_((Entity)broom);
        if (!player.m_7500_()) {
            player.m_21205_().m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        toolTip.add((Component)this.getText("broom").m_130940_(GREEN));
        toolTip.add((Component)this.getText("broom_recovery").m_130940_(GREEN));
        toolTip.add((Component)this.empty());
        toolTip.add((Component)this.getText("broom_forward").m_130940_(GOLD));
        toolTip.add((Component)this.getText("broom_strafe").m_130940_(GOLD));
        toolTip.add((Component)this.getText("broom_jump").m_130940_(GOLD));
        toolTip.add((Component)this.getText("broom_face").m_130940_(GOLD));
    }

    @Override
    public int getMaxMF(ItemStack stack) {
        int addMaxMF = this.getEnchantLevel(EnchantInit.maxMFUP, stack) * 10 * (this.maxMF / 100);
        return this.maxMF + addMaxMF;
    }

    @Override
    public void setMaxMF(int maxMF) {
        this.maxMF = maxMF;
    }

    public int getEnchantLevel(Enchantment enchant, ItemStack stack) {
        return Math.min(EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)stack), 10);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack) ? 3211145 : 50175;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getMF(stack) != 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(13, Math.round(13.0f * (float)this.getMF(stack) / (float)this.getMaxMF(stack)));
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }
}

