/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.api.iitem.IAmorUtil;
import sweetmagic.api.iitem.IHarness;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;

public class SMHarness
extends ArmorItem
implements IHarness,
IAmorUtil {
    public int maxMF;
    public final int data;
    private int tickTime = 0;
    private final String name;
    private static final String NOT_ACTIVE = "notActive";
    private Multimap<Attribute, AttributeModifier> atMap = ImmutableMultimap.of();

    public SMHarness(String name, int data, int maxMF) {
        super(IAmorUtil.getArmorMaterial(data), EquipmentSlot.FEET, IAmorUtil.getArmorPro());
        this.name = name;
        this.data = data;
        this.setMaxMF(maxMF);
        ItemInit.itemMap.put((Item)this, this.name);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        CompoundTag tags;
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            return super.m_7203_(world, player, hand);
        }
        tags.m_128379_(NOT_ACTIVE, !(tags = stack.m_41784_()).m_128471_(NOT_ACTIVE));
        if (world.m_5776_()) {
            boolean notActive = tags.m_128471_(NOT_ACTIVE);
            this.playSound(player.m_9236_(), player, SoundInit.STOVE_OFF, 0.1f, !notActive ? 0.75f : 1.25f);
            player.m_213846_((Component)this.getTipArray(new Object[]{((MutableComponent)stack.m_41611_()).m_130940_(GOLD), this.getText(notActive ? "acce_invalid" : "acce_active").m_130940_(notActive ? RED : GREEN)}));
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        CompoundTag tags = stack.m_41784_();
        boolean notActive = tags.m_128471_(NOT_ACTIVE);
        if (notActive) {
            if (!this.atMap.isEmpty()) {
                player.m_21204_().m_22161_(this.atMap);
                this.atMap = ImmutableMultimap.of();
            }
        } else {
            ImmutableMultimap.Builder map = ImmutableMultimap.builder();
            map.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(IAmorUtil.SMUPSPEED, "Move Speed", (double)0.04f, AttributeModifier.Operation.ADDITION));
            ImmutableMultimap mulMap = map.build();
            if (!mulMap.isEmpty()) {
                this.atMap = mulMap;
                player.m_21204_().m_22178_((Multimap)mulMap);
            }
        }
        if (this.data == 1) {
            player.f_19789_ = 0.0f;
            if (!player.m_7500_() && !player.m_5833_() && player.m_150110_().f_35935_ && !this.isMFEmpty(stack)) {
                if (world.m_5776_()) {
                    RandomSource rand = world.m_213780_();
                    Vec3 vec = player.m_20184_();
                    float x = (float)player.f_19854_ - 0.5f + rand.m_188501_();
                    float y = (float)player.f_19855_ - 0.4f + rand.m_188501_() * 0.5f;
                    float z = (float)player.f_19856_ - 0.5f + rand.m_188501_();
                    float f1 = (float)(-vec.f_82479_) * 0.5f;
                    float f2 = -0.025f + (float)(-vec.f_82480_) * 0.5f;
                    float f3 = (float)(-vec.f_82481_) * 0.5f;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)x, (double)y, (double)z, (double)f1, (double)f2, (double)f3);
                } else if (!player.m_6144_()) {
                    Vec3 vec = player.m_20184_();
                    if (vec.f_82480_ < 0.0) {
                        player.m_20256_(new Vec3(vec.f_82479_, 0.0, vec.f_82481_));
                    }
                }
            }
        }
        if (this.getMF(stack) < 1 || ++this.tickTime % 60 != 0) {
            return;
        }
        this.tickTime = 0;
        int useMF = 0;
        int costDown = Math.min(99, this.getEnchantLevel(EnchantInit.mfCostDown, stack) * 7);
        if (this.data != 0 && !player.m_7500_() && !player.m_5833_() && player.m_150110_().f_35935_) {
            useMF = 30;
            if (this.isMFEmpty(stack)) {
                player.m_150110_().f_35936_ = false;
            }
        }
        if (costDown > 0) {
            useMF = (int)((float)useMF * ((float)(100 - costDown) / 100.0f));
        }
        this.setMF(stack, this.getMF(stack) - useMF);
    }

    @Override
    public int getMaxMF(ItemStack stack) {
        int addMaxMF = this.getEnchantLevel(EnchantInit.maxMFUP, stack) * 10 * (this.maxMF / 100);
        return this.maxMF + addMaxMF;
    }

    @Override
    public void setMaxMF(int maxMF) {
        this.maxMF = maxMF;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack) ? 3211145 : 50175;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getMF(stack) != 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(13, Math.round(13.0f * (float)this.getMF(stack) / (float)this.getMaxMF(stack)));
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    public void initializeClient(Consumer<IClientItemExtensions> con) {
        con.accept(IAmorUtil.ArmorRobeRender.INSTANCE);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String typeIn) {
        return "sweetmagic:textures/block/empty.png";
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return ENCHACATELIST.contains(enchant.f_44672_) || enchant != Enchantments.f_44986_ && enchant.f_44672_.m_7454_(stack.m_41720_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> toolTip, TooltipFlag flag) {
        toolTip.add((Component)this.getText("aether_boot").m_130940_(GOLD));
        toolTip.add((Component)this.getText("aether_boot_move").m_130940_(GOLD));
        toolTip.add((Component)this.getText("aether_boot_move_active").m_130940_(RED));
        if (this.data >= 1) {
            toolTip.add((Component)this.getText("angel_harness").m_130940_(GOLD));
        }
    }
}

