/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.event.KeyPressEvent;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.item.magic.SMAcce;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.key.SMKeybind;
import sweetmagic.util.SchematicExport;

public class StartLightWand
extends SMItem
implements IMFTool {
    public int maxMF;
    public final int data;

    public StartLightWand(String name, int data) {
        super(name, StartLightWand.setItem(SweetMagicCore.smMagicTab));
        this.setMaxMF(data == 0 ? 50000 : 0);
        this.data = data;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder build = ImmutableMultimap.builder();
            build.putAll(map);
            build.put((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(SMAcce.BLOCK_REACH, "Block Reach", 32.0, AttributeModifier.Operation.ADDITION));
            map = build.build();
        }
        return map;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext con) {
        Player player = con.m_43723_();
        CompoundTag tag = stack.m_41784_();
        Level world = con.m_43725_();
        BlockPos pos = this.getPos(con.m_8083_(), con.m_43720_(), con.m_43719_());
        if (!player.m_6144_()) {
            tag.m_128405_("startX", pos.m_123341_());
            tag.m_128405_("startY", pos.m_123342_());
            tag.m_128405_("startZ", pos.m_123343_());
            if (world.m_5776_()) {
                player.m_213846_((Component)this.getText("posregi_start").m_130940_(GREEN));
            }
        } else {
            tag.m_128405_("endX", pos.m_123341_());
            tag.m_128405_("endY", pos.m_123342_());
            tag.m_128405_("endZ", pos.m_123343_());
            if (world.m_5776_()) {
                player.m_213846_((Component)this.getText("posregi_end").m_130940_(GREEN));
            }
        }
        if (world.m_5776_()) {
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void registerBlock(Level world, BlockState state, BlockPos pos, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        Block block = state.m_60734_();
        tag.m_128359_("blockId", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
        VoxelShape voxel = block.m_49966_().m_60812_((BlockGetter)world, pos);
        tag.m_128379_("isFull", voxel.equals(Shapes.m_83144_()));
    }

    public void setBlock(Level world, Player player, ItemStack stack) {
        if (!player.m_7500_() && this.isMFEmpty(stack)) {
            return;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags == null || !tags.m_128441_("startX") && !tags.m_128441_("endX") || !tags.m_128441_("blockId") || !tags.m_128441_("state") || player.m_21023_(PotionInit.non_destructive)) {
            return;
        }
        BlockPos startPos = tags.m_128441_("startX") ? new BlockPos(tags.m_128451_("startX"), tags.m_128451_("startY"), tags.m_128451_("startZ")) : new BlockPos(tags.m_128451_("endX"), tags.m_128451_("endY"), tags.m_128451_("endZ"));
        BlockPos endPos = tags.m_128441_("endX") ? new BlockPos(tags.m_128451_("endX"), tags.m_128451_("endY"), tags.m_128451_("endZ")) : new BlockPos(tags.m_128451_("startX"), tags.m_128451_("startY"), tags.m_128451_("startZ"));
        Iterable posList = BlockPos.m_121940_((BlockPos)startPos, (BlockPos)endPos);
        BlockState staet = NbtUtils.m_129241_((CompoundTag)tags.m_128469_("state"));
        Block block = this.getBlock(tags);
        Item blockItem = new ItemStack((ItemLike)block).m_41720_();
        boolean isExchange = tags.m_128471_("isExchange");
        boolean isCreative = player.m_7500_();
        boolean isSetBlock = false;
        int mf = this.getMF(stack);
        int costDown = Math.min(10, this.getEnchaLevel(stack, EnchantInit.mfCostDown));
        float useMF = 0.0f;
        float useMFRate = 1.0f - (float)costDown * 0.05f;
        int count = 0;
        int maxBlockCount = 0;
        List<ItemStack> stackList = player.m_150109_().f_35974_.stream().filter(s -> s.m_150930_(blockItem)).toList();
        ArrayList dropList = new ArrayList();
        for (ItemStack item : stackList) {
            maxBlockCount += item.m_41613_();
        }
        if (this.data == 0 && !player.m_7500_() && maxBlockCount <= 0) {
            return;
        }
        if (this.data == 1) {
            if (SchematicExport.saveSchematic(SchematicExport.SCHEMATICS, staet.m_60734_().m_49954_().getString(), false, world, startPos, endPos)) {
                player.m_213846_((Component)this.getText("register_struc").m_130940_(GREEN));
            }
            return;
        }
        for (BlockPos pos : posList) {
            BlockState targetState = world.m_8055_(pos);
            Block targetBlock = targetState.m_60734_();
            if (targetBlock == block || targetState.m_155947_() || !isExchange && !targetState.m_60795_()) continue;
            if (isExchange && !targetState.m_60795_() && world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                dropList.addAll(Block.m_49874_((BlockState)targetState, (ServerLevel)server, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)stack));
            }
            world.m_7731_(pos, staet, 3);
            useMF += 1.0f * useMFRate;
            isSetBlock = true;
            if (isCreative || !(useMF >= (float)mf) && ++count < maxBlockCount) continue;
            break;
        }
        if (isSetBlock) {
            SoundType sound = block.getSoundType(staet, (LevelReader)world, player.m_20183_(), (Entity)player);
            this.playSound(world, player, sound.m_56777_(), (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        }
        if (!isCreative) {
            this.setMF(stack, mf - (int)useMF);
            for (ItemStack item : stackList) {
                int shrinkCount = Math.min(Math.min(item.m_41613_(), maxBlockCount), count);
                item.m_41774_(shrinkCount);
                if ((maxBlockCount -= shrinkCount) > 0 && (count -= shrinkCount) > 0) continue;
                break;
            }
            if (!dropList.isEmpty() && !world.m_5776_()) {
                BlockPos p = player.m_20183_();
                dropList.forEach(s -> world.m_7967_((Entity)new ItemEntity(world, (double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), s)));
            }
        }
    }

    public void resetPos(Player player, ItemStack stack) {
        CompoundTag tags = stack.m_41784_();
        tags.m_128473_("startX");
        tags.m_128473_("startY");
        tags.m_128473_("startZ");
        tags.m_128473_("endX");
        tags.m_128473_("endY");
        tags.m_128473_("endZ");
        player.m_213846_((Component)this.getText("posremo").m_130940_(RED));
        this.playSound((Entity)player, SoundEvents.f_12490_, 0.25f, player.m_217043_().m_188501_() * 0.1f + 1.2f);
    }

    public void changeExchange(Player player, ItemStack stack) {
        CompoundTag tags;
        tags.m_128379_("isExchange", !(tags = stack.m_41784_()).m_128471_("isExchange"));
        player.m_213846_((Component)this.getText(tags.m_128471_("isExchange") ? "exchange_mode" : "set_mode").m_130940_(GREEN));
        this.playSound((Entity)player, SoundEvents.f_12490_, 0.25f, player.m_217043_().m_188501_() * 0.1f + 1.2f);
    }

    public BlockPos getPos(BlockPos pos, Vec3 vec, Direction face) {
        boolean isOver = false;
        double x = Math.abs((double)((int)vec.f_82479_) - vec.f_82479_);
        double y = Math.abs((double)((int)vec.f_82480_) - vec.f_82480_);
        double z = Math.abs((double)((int)vec.f_82481_) - vec.f_82481_);
        double size = 0.15;
        switch (face) {
            case UP: 
            case DOWN: {
                isOver = x > 1.0 - size || x < size || z > 1.0 - size || z < size;
                break;
            }
            case NORTH: 
            case SOUTH: {
                isOver = x > 1.0 - size || x < size || y > 1.0 - size || y < size;
                break;
            }
            case WEST: 
            case EAST: {
                isOver = y > 1.0 - size || y < size || z > 1.0 - size || z < size;
            }
        }
        return isOver ? pos.m_121945_(face) : pos;
    }

    public Block getBlock(CompoundTag tags) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tags.m_128461_("blockId")));
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name).m_130940_(GOLD));
        for (int i = 0; i < 4; ++i) {
            toolTip.add((Component)this.getText("startlight_wand_operation." + i).m_130940_(GREEN));
        }
        toolTip.add((Component)this.empty());
        MutableComponent keyNext = KeyPressEvent.getKeyName(SMKeybind.NEXT);
        MutableComponent keyBack = KeyPressEvent.getKeyName(SMKeybind.BACK);
        toolTip.add((Component)this.getTipArray(new Object[]{keyNext.m_6881_(), this.getText("key"), this.getText("startlight_wand_key1").m_130940_(WHITE)}).m_130940_(RED));
        toolTip.add((Component)this.getTipArray(new Object[]{keyBack.m_6881_(), this.getText("key"), this.getText("startlight_wand_key2").m_130940_(WHITE)}).m_130940_(RED));
        toolTip.add((Component)this.empty());
        CompoundTag tag = stack.m_41784_();
        toolTip.add((Component)this.getTipArray(new Object[]{this.getLabel("MF: "), this.getLabel(this.format(this.getMF(stack)), WHITE)}).m_130940_(GREEN));
        String startPos = tag.m_128441_("startX") ? tag.m_128451_("startX") + ", " + tag.m_128451_("startY") + ", " + tag.m_128451_("startZ") : this.getText("unregistered").getString();
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("start_pos"), this.getLabel(startPos, WHITE)}).m_130940_(GREEN));
        String endPos = tag.m_128441_("endX") ? tag.m_128451_("endX") + ", " + tag.m_128451_("endY") + ", " + tag.m_128451_("endZ") : this.getText("unregistered").getString();
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("end_pos"), this.getLabel(endPos, WHITE)}).m_130940_(GREEN));
        String block = tag.m_128441_("blockId") ? this.getBlock(tag).m_49954_().getString() : this.getText("unregistered").getString();
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("set_block"), this.getLabel(block, WHITE)}).m_130940_(GREEN));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("star_mode"), this.getText(tag.m_128471_("isExchange") ? "exchange_mode" : "set_mode").m_130940_(WHITE)}).m_130940_(GREEN));
    }

    @Override
    public int getMaxMF(ItemStack stack) {
        int addMaxMF = this.getEnchantLevel(EnchantInit.maxMFUP, stack) * 10 * (this.maxMF / 100);
        return this.maxMF + addMaxMF;
    }

    @Override
    public void setMaxMF(int maxMF) {
        this.maxMF = maxMF;
    }

    public int getEnchantLevel(Enchantment enchant, ItemStack stack) {
        return Math.min(EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)stack), 10);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack) ? 3211145 : 50175;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getMF(stack) != 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(13, Math.round(13.0f * (float)this.getMF(stack) / (float)this.getMaxMF(stack)));
    }
}

