/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.item.sm.SMWand;

public class CosmicWand
extends SMWand
implements ISMTip {
    private final int data;
    private final SMElement ele;
    private final boolean isScope;
    private final boolean isHammer;
    private ItemStack stack = ItemStack.f_41583_;

    public CosmicWand(String name, int tier, int maxMF, int slot, SMElement ele) {
        super(name, tier, maxMF, slot);
        this.ele = ele;
        this.data = 0;
        this.isScope = false;
        this.isHammer = false;
    }

    public CosmicWand(String name, int tier, int maxMF, int slot, SMElement ele, boolean isScope) {
        super(name, tier, maxMF, slot);
        this.ele = ele;
        this.data = 0;
        this.isScope = isScope;
        this.isHammer = false;
    }

    public CosmicWand(String name, int tier, int maxMF, int slot, SMElement ele, boolean isHammer, int data) {
        super(name, tier, maxMF, slot);
        this.ele = ele;
        this.data = data;
        this.isScope = false;
        this.isHammer = isHammer;
    }

    @Override
    public SMElement getWandElement() {
        return this.ele;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void shotSound(Player player) {
        if (this.isScope()) {
            this.playSound(player.m_9236_(), player, SoundInit.RIFLE_SHOT, 0.2f, 1.0f);
        } else {
            super.shotSound(player);
        }
    }

    @Override
    public List<Component> addTip() {
        ArrayList<Component> tipList = new ArrayList<Component>();
        if (this.isScope()) {
            tipList.add((Component)this.getText("scope_sneak").m_130940_(GREEN));
            tipList.add((Component)this.getText("scope_shot").m_130940_(GREEN));
            tipList.add((Component)this.getText("scope_dig").m_130940_(RED));
        }
        return tipList;
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.isScope()) {
            return 1.0f;
        }
        if (this.isHammer) {
            return super.m_8102_(stack, state) * 2.0f;
        }
        return super.m_8102_(stack, state);
    }

    @Override
    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        return !this.isScope();
    }

    @Override
    public void setElementBonus(WandInfo wInfo, MagicInfo mInfo) {
        int level = this.getEnchaLevel(wInfo.getStack(), EnchantInit.elementBonus);
        this.elementBonusPower = !this.ele.is(SMElement.ALL) ? (this.isElementEqual(mInfo.getMagicItem(), this.ele) ? 0.75f + (float)level * 0.05f : 0.0f) : 0.25f + (float)level * 0.025f;
    }

    @Override
    public ItemStack getRenderStack(ItemStack stack) {
        if (this.data == 1) {
            if (this.stack.m_41619_()) {
                this.stack = new ItemStack((ItemLike)ItemInit.japanese_umbrella);
            }
            return this.stack;
        }
        return stack;
    }

    @Override
    public void renderWand(PoseStack pose, MultiBufferSource buf, Player player, float parTick) {
        if (!this.isScope() && this.data == 0) {
            super.renderWand(pose, buf, player, parTick);
        } else if (this.data == 1) {
            pose.m_85837_(0.1, 0.8, -0.4);
            pose.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            super.renderWand(pose, buf, player, parTick);
        } else if (this.data == 2) {
            pose.m_85837_(0.7, 0.625, 0.0);
            pose.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            super.renderWand(pose, buf, player, parTick);
        } else {
            pose.m_85837_(0.6, 0.5, 0.325);
            pose.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            pose.m_85845_(Vector3f.f_122227_.m_122240_(105.0f));
            super.renderWand(pose, buf, player, parTick);
        }
    }
}

