/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraftforge.event.ForgeEventFactory;
import sweetmagic.init.block.sm.SMSapling;
import sweetmagic.init.item.magic.SMTierItem;
import sweetmagic.worldgen.tree.gen.PrismTreeGen;

public class MagicMeal
extends SMTierItem {
    public MagicMeal(String name) {
        super(name, 1);
    }

    public InteractionResult m_6225_(UseOnContext con) {
        Level world = con.m_43725_();
        RandomSource rand = world.m_213780_();
        BlockPos pos = con.m_8083_();
        Block block = world.m_8055_(pos).m_60734_();
        Player player = con.m_43723_();
        ItemStack stack = player.m_21205_();
        if (!world.m_5776_() && block instanceof FlowerBlock) {
            FlowerBlock flower = (FlowerBlock)block;
            int chance = rand.m_188503_(7) + 4;
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.spawnItem(world, pos, new ItemStack((ItemLike)flower, chance));
            this.playSound((Entity)player, SoundEvents.f_11929_, 0.5f, 1.0f / (rand.m_188501_() * 0.4f + 1.2f) + 0.5f);
        } else if (block instanceof SMSapling) {
            SMSapling sap = (SMSapling)block;
            PrismTreeGen tree = new PrismTreeGen(sap.getLog().m_49966_(), sap.getLeaves(), 0);
            tree.generate(world, rand, pos);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.playSound((Entity)player, SoundEvents.f_11929_, 0.5f, 1.0f / (rand.m_188501_() * 0.4f + 1.2f) + 0.5f);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Witch) {
            Witch witch = (Witch)entity;
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                Villager villager = (Villager)witch.m_21406_(EntityType.f_20492_, false);
                villager.m_6518_((ServerLevelAccessor)server, server.m_6436_(villager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
                villager.m_35483_(server);
                villager.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                if (!server.m_5776_()) {
                    server.m_5898_((Player)null, 1027, witch.m_20183_(), 0);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                ForgeEventFactory.onLivingConvert((LivingEntity)witch, (LivingEntity)villager);
                this.playSound((Entity)player, SoundEvents.f_11929_, 0.5f, 1.0f / (server.m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
            }
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name + "_flower").m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "_sapling").m_130940_(GREEN));
    }
}

