/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.event.AbstractChopTaskEvent;
import sweetmagic.api.util.ISMTip;
import sweetmagic.event.KeyPressEvent;
import sweetmagic.init.ItemInit;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.key.SMKeybind;
import sweetmagic.util.WorldHelper;

public class SMAxe
extends AxeItem
implements ISMTip {
    private final int data;

    public SMAxe(String name, int data, int value) {
        super((Tier)(data == 2 ? Tiers.NETHERITE : Tiers.DIAMOND), 6.0f + (float)data * 0.5f, -3.1f + (float)data * 0.25f, SMItem.setItem(value, SweetMagicCore.smMagicTab));
        this.data = data;
        ItemInit.itemMap.put((Item)this, name);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity living) {
        if (this.checkBlock(world, pos) && !living.m_6144_() && living instanceof Player) {
            Player player = (Player)living;
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_()));
            world.m_46961_(pos, false);
            WorldHelper.createLootDrop(dropList, world, player.f_19854_, player.f_19855_, player.f_19856_);
            player.getPersistentData().m_128473_("isCancelAxe");
            MinecraftForge.EVENT_BUS.register((Object)new TreeChopTask(pos, player, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)stack) + 1 + this.data));
        }
        return super.m_6813_(stack, world, state, pos, living);
    }

    public boolean checkBlock(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> toolTip, TooltipFlag flag) {
        toolTip.add((Component)this.getText("alternative_axe").m_130940_(GREEN));
        MutableComponent key = KeyPressEvent.getKeyName(SMKeybind.SPECIAL);
        toolTip.add((Component)this.getTipArray(new Object[]{key.m_6881_(), this.getText("key"), this.getText("alternative_axe_cancel").m_130940_(WHITE)}).m_130940_(GOLD));
    }

    public void cancelAction(Player player) {
        player.getPersistentData().m_128379_("isCancelAxe", true);
        player.m_213846_((Component)this.getText("axe_cancel").m_130940_(GREEN));
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.33f, player.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingot) {
        return ingot.m_150930_(ItemInit.alternative_ingot);
    }

    public class TreeChopTask
    extends AbstractChopTaskEvent {
        protected final List<Direction> allFace;

        public TreeChopTask(BlockPos start, Player player, int blockTick) {
            super(start, player, blockTick);
            this.allFace = Arrays.asList(Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
        }

        @Override
        @SubscribeEvent
        public void chopChop(TickEvent.ServerTickEvent event) {
            if (event.side.isClient() || this.player == null || this.player.getPersistentData().m_128471_("isCancelAxe")) {
                this.player.getPersistentData().m_128473_("isCancelAxe");
                this.finish();
                return;
            }
            int tick = this.blockTick;
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            boolean isFirst = this.posSet.isEmpty();
            while (tick > 0) {
                if (this.targetblockList.isEmpty()) {
                    this.finish();
                    return;
                }
                BlockPos pos = (BlockPos)this.targetblockList.get(0);
                this.targetblockList.remove(0);
                if (isFirst) {
                    this.allFace.forEach(f -> this.checkLog(pos.m_121945_(f)));
                    isFirst = false;
                    continue;
                }
                if (!this.checkBlock(this.world, pos)) continue;
                BlockState state = this.world.m_8055_(pos);
                if (!this.isCreative) {
                    dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.world), (BlockPos)pos, (BlockEntity)this.world.m_7702_(pos), (Entity)this.player, (ItemStack)this.player.m_21205_()));
                }
                boolean isLeave = this.checkLeave(this.world, pos);
                this.world.m_46961_(pos, false);
                if (isLeave) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (int z = -1; z <= 1; ++z) {
                                this.checkLog(WorldHelper.offset(pos, x, y, z));
                            }
                        }
                    }
                } else {
                    this.allFace.forEach(f -> this.checkLog(pos.m_121945_(f)));
                }
                --tick;
            }
            WorldHelper.createLootDrop(dropList, this.world, this.player.f_19854_, this.player.f_19855_, this.player.f_19856_);
        }

        public void checkLog(BlockPos pos) {
            if (!this.posSet.contains(pos) && this.checkBlock(this.world, pos)) {
                this.targetblockList.add(pos);
                this.posSet.add(pos);
            }
        }

        @Override
        public boolean checkBlock(Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
        }

        public boolean checkLeave(Level world, BlockPos pos) {
            return world.m_8055_(pos).m_204336_(BlockTags.f_13035_);
        }
    }
}

