/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.fluid.BucketWrapper;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.util.WorldHelper;

public class SMBucket
extends SMItem {
    public final int data;

    public SMBucket(String name, int data) {
        super(name, new Item.Properties().m_41491_(SweetMagicCore.smMagicTab).m_41487_(1));
        this.data = data;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return this.shrinkWater(stack.m_41777_(), 1000);
    }

    public ItemStack shrinkWater(ItemStack stack, int shrink) {
        FluidStack fluid = this.getFluidStack(stack);
        if (fluid.isEmpty() || fluid.getAmount() <= 0) {
            new ItemStack((ItemLike)ItemInit.alt_bucket);
        }
        fluid.shrink(shrink);
        this.saveFluid(stack, fluid);
        if (fluid.isEmpty() || fluid.getAmount() <= 0) {
            stack = new ItemStack((ItemLike)ItemInit.alt_bucket);
        }
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult result;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)world, (ItemStack)stack, (HitResult)(result = SMBucket.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)));
        if (ret != null) {
            return ret;
        }
        BlockPos pos = result.m_82425_();
        Direction face = result.m_82434_();
        BlockPos pos1 = pos.m_121945_(face);
        if (!world.m_7966_(player, pos) || !player.m_36204_(pos1, face, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.getFluid() == Fluids.f_76191_) {
            BlockState state1 = world.m_8055_(pos);
            Block block = state1.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup pickup = (BucketPickup)block;
                ItemStack stack1 = pickup.m_142598_((LevelAccessor)world, pos, state1);
                if (stack1.m_150930_(Items.f_42447_)) {
                    stack1 = new ItemStack((ItemLike)ItemInit.alt_bucket_water);
                } else if (stack1.m_150930_(Items.f_42448_)) {
                    stack1 = new ItemStack((ItemLike)ItemInit.alt_bucket_lava);
                } else {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                if (!stack1.m_41619_()) {
                    pickup.getPickupSound(state1).ifPresent(s -> player.m_5496_(s, 1.0f, 1.0f));
                    Item item = stack1.m_41720_();
                    if (item instanceof SMBucket) {
                        SMBucket bucket = (SMBucket)item;
                        bucket.rangeDrainFluid(world, pos, stack1);
                    }
                    return InteractionResultHolder.m_19092_((Object)stack1, (boolean)world.m_5776_());
                }
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!this.checkFluid(world, pos, state)) {
            if (this.emptyDrain(player, world, pos, result, stack)) {
                stack = player.m_7500_() ? stack : this.fillStack(stack);
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
            }
            FluidState fState = world.m_6425_(pos1);
            if (!fState.m_76178_() && !fState.m_192917_(this.getFluid())) {
                world.m_7731_(pos1, this.getFluid().m_76145_().m_76188_(), 3);
                stack = this.shrinkWater(stack, 1000);
                this.playEmptySound(player, (LevelAccessor)world, pos1);
            }
        } else {
            Block block = state.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup pickup = (BucketPickup)block;
                pickup.getPickupSound(state).ifPresent(s -> player.m_5496_(s, 1.0f, 1.0f));
            }
            this.rangeDrainFluid(world, pos, stack);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean emptyDrain(Player player, Level world, BlockPos pos, BlockHitResult result, ItemStack stack) {
        LiquidBlockContainer liq;
        boolean flag1;
        if (!(this.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        FluidState fluid = world.m_6425_(pos);
        if (fluid.m_192917_((Fluid)Fluids.f_76193_) || fluid.m_192917_((Fluid)Fluids.f_76195_)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        Material material = state.m_60767_();
        boolean flag = state.m_60722_(this.getFluid());
        boolean bl = flag1 = state.m_60795_() || flag || block instanceof LiquidBlockContainer && (liq = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, this.getFluid());
        if (!flag1) {
            return result != null && this.emptyDrain(player, world, result.m_82425_().m_121945_(result.m_82434_()), null, stack);
        }
        if (block instanceof LiquidBlockContainer && (liq = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, this.getFluid())) {
            liq.m_7361_((LevelAccessor)world, pos, state, ((FlowingFluid)this.getFluid()).m_76068_(false));
            this.playEmptySound(player, (LevelAccessor)world, pos);
            return true;
        }
        if (!world.m_5776_() && flag && !material.m_76332_()) {
            world.m_46961_(pos, true);
        }
        if (!world.m_7731_(pos, this.getFluid().m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)world, pos);
        return true;
    }

    protected void playEmptySound(Player player, LevelAccessor world, BlockPos pos) {
        SoundEvent sound = this.getFluid().getFluidType().getSound(player, (BlockGetter)world, pos, SoundActions.BUCKET_EMPTY);
        if (sound == null) {
            sound = this.getFluid().m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        world.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public ItemStack fillStack(ItemStack stack) {
        FluidStack fluid = this.getFluidStack(stack);
        fluid.shrink(1000);
        if (fluid.getAmount() <= 0) {
            stack = new ItemStack((ItemLike)ItemInit.alt_bucket);
            CompoundTag tags = ((SMBucket)stack.m_41720_()).getTag(stack);
            CompoundTag fluidNBT = new CompoundTag();
            fluid = new FluidStack(Fluids.f_76191_, 0);
            fluid.writeToNBT(fluidNBT);
            tags.m_128365_("fluid", (Tag)fluidNBT);
        }
        this.saveFluid(stack, fluid);
        return stack;
    }

    public ItemStack drainStack(ItemStack stack, Fluid flu, int amount) {
        FluidStack fluid = this.getFluidStack(stack);
        if (fluid.isEmpty() || fluid.getAmount() <= 0) {
            fluid = new FluidStack(fluid, amount);
        } else {
            fluid.grow(amount);
        }
        this.saveFluid(stack, fluid);
        return stack;
    }

    public void rangeDrainFluid(Level world, BlockPos pos, ItemStack stack) {
        int fluidAmount = 0;
        int range = 5;
        Iterable<BlockPos> pList = WorldHelper.getRangePos(pos, range);
        for (BlockPos p : pList) {
            FluidState fState = world.m_6425_(p);
            if (!fState.m_205070_(this.geteFluidTag())) continue;
            BlockState state = world.m_8055_(p);
            if (fState.m_76152_().m_6212_(this.getFluid()) && state.m_61138_((Property)BlockStateProperties.f_61422_) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61422_) == 0) {
                ++fluidAmount;
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                world.m_7731_(p, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
                continue;
            }
            world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
        }
        FluidStack fluid = this.getFluidStack(stack);
        if (fluid.isEmpty()) {
            fluid = new FluidStack(this.getFluid(), 1000 * Math.max(fluidAmount, 1));
        } else {
            fluid.setAmount(fluid.getAmount() + 1000 * fluidAmount);
        }
        this.saveFluid(stack, fluid);
    }

    private boolean checkFluid(Level world, BlockPos pos, BlockState state) {
        FluidState fluid = world.m_6425_(pos);
        return fluid != null && fluid.m_76152_().m_6212_(this.getFluid());
    }

    public FluidStack getFluidStack(ItemStack stack) {
        return FluidStack.loadFluidStackFromNBT((CompoundTag)this.getTag(stack).m_128469_("fluid"));
    }

    public void saveFluid(ItemStack stack, FluidStack fluid) {
        CompoundTag tags = this.getTag(stack);
        CompoundTag fluidNBT = new CompoundTag();
        fluid.writeToNBT(fluidNBT);
        tags.m_128365_("fluid", (Tag)fluidNBT);
    }

    public TagKey<Fluid> geteFluidTag() {
        switch (this.data) {
            case 1: {
                return FluidTags.f_13131_;
            }
            case 2: {
                return FluidTags.f_13132_;
            }
        }
        return null;
    }

    public Fluid getFluid() {
        switch (this.data) {
            case 1: {
                return Fluids.f_76193_;
            }
            case 2: {
                return Fluids.f_76195_;
            }
        }
        return Fluids.f_76191_;
    }

    public CompoundTag getTag(ItemStack stack) {
        CompoundTag tags = stack.m_41784_();
        if (!tags.m_128441_("fluid")) {
            CompoundTag fluidNBT = new CompoundTag();
            FluidStack fluid = new FluidStack(this.getFluid(), 0);
            fluid.writeToNBT(fluidNBT);
            tags.m_128365_("fluid", (Tag)fluidNBT);
        }
        return tags;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag tags) {
        return new BucketWrapper(stack, this);
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        FluidStack fluid = this.getFluidStack(stack);
        if (fluid.isEmpty()) {
            return;
        }
        toolTip.add((Component)this.getTipArray(new Object[]{fluid.getDisplayName().getString(), ": ", this.getLabel(String.format("%,.1f", Float.valueOf((float)fluid.getAmount() * 0.001f)) + "B", GREEN)}));
    }
}

