/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iitem.IFood;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.util.PlayerHelper;

public class SMFood
extends SMItem
implements IFood {
    private final int data;
    private final boolean isDrink;
    private final int healAmount;
    private final float saturation;
    private final boolean isQuality;
    private int foodLevel;
    private IFood.FoodType foodType;

    public SMFood(String name, int healAmount, float saturation, int data, boolean isDrink) {
        super(name, SMItem.setItem(SweetMagicCore.smFoodTab).m_41489_(SMFood.foodBuild(healAmount, saturation)));
        this.data = data;
        this.isDrink = isDrink;
        this.healAmount = healAmount;
        this.saturation = saturation;
        ItemInit.foodList.add(this);
        this.isQuality = false;
        this.foodLevel = 0;
        this.foodType = null;
    }

    public SMFood(String name, int healAmount, float saturation, int data, IFood.FoodType foodType, int foodLevel, boolean isDrink) {
        super(name, SMItem.setItem(SweetMagicCore.smFoodTab).m_41489_(SMFood.foodBuild(healAmount, saturation)));
        this.data = data;
        this.isDrink = isDrink;
        this.healAmount = healAmount;
        this.saturation = saturation;
        ItemInit.foodList.add(this);
        this.isQuality = true;
        this.foodLevel = foodLevel;
        this.foodType = foodType;
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        int foodLevel = this.getQualityValue(stack);
        return foodLevel <= 0 ? super.getFoodProperties(stack, entity) : this.foodBuild(stack, this.healAmount, this.saturation);
    }

    protected void onFoodEaten(Level world, Player player, ItemStack stack) {
        this.onFoodEat(world, (LivingEntity)player, stack);
    }

    public void onFoodEat(Level world, LivingEntity entity, ItemStack stack) {
        switch (this.data) {
            case 1: {
                entity.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_));
                break;
            }
            case 2: {
                entity.m_20095_();
                break;
            }
            case 3: {
                entity.m_5634_(2.0f);
                break;
            }
            case 4: {
                this.addPotion(entity, MobEffects.f_19607_, 1800, 0);
                break;
            }
            case 5: {
                this.addPotion(entity, PotionInit.mfcostdown, 2400, 0);
                break;
            }
            case 6: {
                this.addPotion(entity, MobEffects.f_19604_, 100, 0);
                break;
            }
            case 7: {
                entity.m_5634_(entity.m_21233_() * 0.2f);
                break;
            }
            case 8: {
                RandomSource rand = world.m_213780_();
                List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (Entity)entity, e -> e.m_6084_() && (!(e instanceof Enemy) || e instanceof Zombie), 5.0);
                for (LivingEntity e2 : entityList) {
                    SimpleParticleType par = ParticleTypes.f_123748_;
                    if (e2 instanceof Enemy) {
                        e2.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 1, true, false));
                        par = ParticleTypes.f_123767_;
                    } else {
                        e2.m_5634_(4.0f);
                    }
                    if (!(world instanceof ServerLevel)) continue;
                    ServerLevel sever = (ServerLevel)world;
                    for (int i = 0; i < 4; ++i) {
                        float x = (float)(e2.m_20185_() + (double)(rand.m_188501_() * 1.5f) - 0.5);
                        float y = (float)(e2.m_20186_() + (double)rand.m_188501_() - (double)rand.m_188501_() + 1.0);
                        float z = (float)(e2.m_20189_() + (double)(rand.m_188501_() * 1.5f) - 0.75);
                        sever.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.1f);
                    }
                }
                break;
            }
            case 9: {
                this.addPotion(entity, PotionInit.increased_experience, 2400, 0);
                break;
            }
            case 10: {
                this.addPotion(entity, PotionInit.increased_recovery, 900, 0);
            }
        }
        int level = this.getQualityValue(stack);
        if (level >= 2) {
            this.addPotion(entity, stack, level);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            this.onFoodEaten(world, player, stack);
        }
        return super.m_5922_(stack, world, entity);
    }

    public void addPotion(LivingEntity entity, MobEffect potion, int time, int level) {
        PlayerHelper.setPotion(entity, potion, level, time);
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.isDrink ? UseAnim.DRINK : UseAnim.EAT;
    }

    public SoundEvent m_6061_() {
        return this.isDrink ? SoundEvents.f_11911_ : super.m_6061_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public static FoodProperties foodBuild(int healAmount, float saturation) {
        return new FoodProperties.Builder().m_38760_(healAmount).m_38758_(saturation).m_38765_().m_38767_();
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        if (this.data == 0) {
            return;
        }
        String text = "";
        switch (this.data) {
            case 1: {
                text = "food_buffclear";
                break;
            }
            case 2: {
                text = "food_fireclear";
                break;
            }
            case 3: {
                text = "food_heal";
                break;
            }
            case 7: {
                text = "food_heal2";
                break;
            }
            case 8: {
                text = "food_heal3";
            }
        }
        if (this.data == 4 || this.data == 5 || this.data == 9 || this.data == 10) {
            int time = 90;
            MutableComponent effect = null;
            switch (this.data) {
                case 4: {
                    time = 90;
                    effect = this.getMCTip("fire_resistance");
                    break;
                }
                case 5: {
                    time = 120;
                    effect = this.getEffectTip("mfcostdown");
                    break;
                }
                case 9: {
                    time = 120;
                    effect = this.getEffectTip("increased_experience");
                    break;
                }
                case 10: {
                    time = 45;
                    effect = this.getEffectTip("increased_recovery");
                }
            }
            toolTip.add((Component)this.getTipArray(new Object[]{this.getText("food_effect"), effect, " (" + time + "sec)"}).m_130940_(GREEN));
        } else {
            toolTip.add((Component)this.getText(text).m_130940_(GREEN));
        }
    }

    @Override
    public boolean isQuality() {
        return this.isQuality;
    }

    @Override
    public void setFoodLevel(int level) {
        this.foodLevel = level;
    }

    @Override
    public int getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public IFood.FoodType getFoodType() {
        return this.foodType;
    }
}

