/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.ItemInit;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.util.WorldHelper;

public class SMHoe
extends HoeItem
implements ISMTip {
    private List<Block> dirtList = Arrays.asList(Blocks.f_50440_, Blocks.f_152481_, Blocks.f_50493_, Blocks.f_50546_);
    private static final BlockState FARM = (BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)BlockStateProperties.f_61423_, (Comparable)Integer.valueOf(7));

    public SMHoe(String name) {
        super((Tier)Tiers.DIAMOND, -3, 0.0f, SMItem.setItem(1024, SweetMagicCore.smMagicTab));
        ItemInit.itemMap.put((Item)this, name);
    }

    public InteractionResult m_6225_(UseOnContext con) {
        boolean isFarm = false;
        Level world = con.m_43725_();
        BlockPos pos = con.m_8083_();
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pos, -1.0, 0.0, -1.0, 1.0, 0.0, 1.0);
        for (BlockPos p : posList) {
            if (this.getHoeState(world, p) == null) continue;
            isFarm = true;
            world.m_7731_(p, FARM, 3);
        }
        if (!isFarm) {
            return this.m_7203_(world, con.m_43723_(), con.m_43724_()).m_19089_();
        }
        Player player = con.m_43723_();
        player.m_21120_(con.m_43724_()).m_41622_(1, (LivingEntity)player, e -> e.m_21190_(con.m_43724_()));
        world.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public BlockState getHoeState(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        if (block == Blocks.f_152549_) {
            if (world.m_5776_()) {
                Block.m_152435_((Level)world, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)Items.f_151017_));
            }
            return Blocks.f_50493_.m_49966_();
        }
        if (this.dirtList.contains(block) && world.m_46859_(pos.m_7494_())) {
            return block == Blocks.f_50546_ ? Blocks.f_50493_.m_49966_() : Blocks.f_50093_.m_49966_();
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockPos p = player.m_20183_();
        ArrayList dropList = new ArrayList();
        Iterable<BlockPos> posList = WorldHelper.getRangePos(p, 15.0);
        for (BlockPos pos : posList) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (!this.checkBlock(player, block)) continue;
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                dropList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)stack));
            }
            this.breakBlock(world, player, block, state, pos);
        }
        if (!dropList.isEmpty()) {
            stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
            dropList.forEach(s -> world.m_7967_((Entity)new ItemEntity(world, (double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), s)));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean checkBlock(Player player, Block block) {
        return player.m_6144_() ? block instanceof TallGrassBlock || block instanceof DoublePlantBlock : block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock;
    }

    public void breakBlock(Level world, Player player, Block block, BlockState state, BlockPos pos) {
        world.m_46961_(pos, false);
        world.m_7471_(pos, false);
        player.m_146850_(GameEvent.f_157794_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> toolTip, TooltipFlag flag) {
        for (int i = 0; i < 3; ++i) {
            toolTip.add((Component)this.getText("alternative_hoe" + i).m_130940_(GREEN));
        }
    }
}

