/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.ItemInit;
import sweetmagic.init.item.sm.SMItem;
import sweetmagic.util.WorldHelper;

public class SMSickle
extends SMItem {
    private final int data;

    public SMSickle(String name, int data, int value) {
        super(name, SweetMagicCore.smMagicTab);
        this.data = data;
        ItemInit.itemMap.put(this, name);
    }

    public int getRange() {
        switch (this.data) {
            case 2: {
                return 5;
            }
        }
        return 2;
    }

    public InteractionResult m_6225_(UseOnContext con) {
        BlockPos pos;
        Level world = con.m_43725_();
        Block block = world.m_8055_(pos = con.m_8083_()).m_60734_();
        if (!(block instanceof IPlantable) && !(block instanceof ISMCrop) || !(world instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel server = (ServerLevel)world;
        if (this.data == 0) {
            return InteractionResult.SUCCESS;
        }
        RandomSource rand = world.m_213780_();
        Player player = con.m_43723_();
        ItemStack stack = player.m_21205_();
        int area = this.getRange();
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pos, area);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (BlockPos p : posList) {
            BonemealableBlock crop;
            BlockState state = world.m_8055_(p);
            Block b = state.m_60734_();
            if (b instanceof ISMCrop) {
                ISMCrop smCrop = (ISMCrop)b;
                if (!smCrop.isMaxAge(state)) continue;
                stackList.addAll(smCrop.rightClickStack(world, state, p));
                smCrop.playCropSound(world, rand, pos);
                continue;
            }
            if (!(b instanceof IPlantable) || !(b instanceof BonemealableBlock) || (crop = (BonemealableBlock)b).m_7370_((BlockGetter)world, p, state, false) || b instanceof StemBlock) continue;
            stackList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)p, (BlockEntity)world.m_7702_(p), (Entity)player, (ItemStack)stack));
            BlockState newState = b.m_49966_();
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            world.m_7731_(p, newState, 3);
        }
        if (!stackList.isEmpty()) {
            world.m_5594_(null, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, 0.5f, 0.8f + rand.m_188501_() * 0.4f);
            stackList.forEach(s -> this.spawnItem(world, player.m_20183_(), (ItemStack)s));
        }
        return InteractionResult.SUCCESS;
    }

    public void getPickPlant(Level world, Player player, BlockPos pos, ItemStack stack) {
        Block block = world.m_8055_(pos).m_60734_();
        if (!(block instanceof IPlantable) && !(block instanceof ISMCrop) || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        int area = this.getRange();
        RandomSource rand = world.m_213780_();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        Iterable<BlockPos> posList = WorldHelper.getRangePos(pos, area);
        for (BlockPos p : posList) {
            BonemealableBlock crop;
            BlockState state = world.m_8055_(p);
            Block b = state.m_60734_();
            if (b instanceof ISMCrop) {
                ISMCrop smCrop = (ISMCrop)b;
                if (!smCrop.isMaxAge(state)) continue;
                stackList.addAll(smCrop.rightClickStack(world, state, p));
                smCrop.playCropSound(world, rand, pos);
                continue;
            }
            if (this.data < 1 || !(b instanceof IPlantable) || !(b instanceof BonemealableBlock) || (crop = (BonemealableBlock)b).m_7370_((BlockGetter)world, p, state, false) || b instanceof StemBlock) continue;
            stackList.addAll(Block.m_49874_((BlockState)state, (ServerLevel)server, (BlockPos)p, (BlockEntity)world.m_7702_(p), (Entity)player, (ItemStack)stack));
            BlockState newState = b.m_49966_();
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            world.m_7731_(p, newState, 3);
        }
        if (stackList.isEmpty()) {
            return;
        }
        stackList.forEach(s -> this.spawnItem(world, player.m_20183_(), (ItemStack)s));
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        if (this.data == 0) {
            toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        } else {
            toolTip.add((Component)this.getText("fluorite_sickle", new Object[]{String.valueOf(this.getRange())}).m_130940_(GREEN));
        }
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingot) {
        return ingot.m_150930_(ItemInit.alternative_ingot);
    }
}

