/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAetherReverse;
import sweetmagic.util.RenderUtil;

public class RenderAetherReverse<T extends TileAetherReverse>
extends RenderAbstractTile<T> {
    public RenderAetherReverse(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        ItemStack stack = ((TileAetherReverse)tile).getInputItem();
        if (stack.m_41619_()) {
            stack = ((TileAetherReverse)tile).stack;
        }
        if (!stack.m_41619_()) {
            pose.m_85836_();
            pose.m_85837_(0.5, 1.575, 0.5);
            int gameTime = ((TileAbstractSM)tile).getClientTime();
            pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 24.0f) * 0.05, 0.0);
            pose.m_85841_(0.35f, 0.35f, 0.35f);
            float f = ((float)gameTime + parTick) / 20.0f;
            Objects.requireNonNull(this);
            float angle = f * 57.295776f;
            pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
            info.itemRender(stack);
            pose.m_85849_();
        }
        this.renderModenRack(tile, info);
    }

    public void renderModenRack(T tile, RenderUtil.RenderInfo info) {
        List<ItemStack> stackList = ((TileAetherReverse)tile).craftList;
        PoseStack pose = info.pose();
        for (int i = 0; i < stackList.size(); ++i) {
            pose.m_85836_();
            pose.m_85841_(0.25f, 0.25f, 0.25f);
            double x = (double)i * -0.8775 + (double)(i / 3) * 2.625;
            double y = (double)(i / 3) * 0.88;
            pose.m_85837_(1.1125 + y, 4.0, 2.875 + x);
            pose.m_85845_(Vector3f.f_122225_.m_122240_(((TileAbstractSM)tile).getRot()));
            pose.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            info.itemRender(stackList.get(i));
            pose.m_85849_();
        }
    }
}

