/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import sweetmagic.init.RenderTypeInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAlternativeTank;
import sweetmagic.util.RenderUtil;

public class RenderAlternativeTank<T extends TileAlternativeTank>
extends RenderAbstractTile<T> {
    public RenderAlternativeTank(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        FluidStack fluid = ((TileAlternativeTank)tile).getContent();
        if (fluid.isEmpty()) {
            return;
        }
        int xd = 0;
        int zd = 0;
        if (xd < 0 || zd < 0) {
            return;
        }
        float[] xBounds = this.getBlockBounds(xd);
        float[] zBounds = this.getBlockBounds(zd);
        VertexConsumer ver = info.buf().m_6299_(RenderTypeInit.SMELTERY_FLUID);
        float curY = 0.125f;
        float h = tile.getFluidProgressScaled(0.775f);
        IClientFluidTypeExtensions ex = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite tex = this.getBlockSprite(ex.getStillTexture(fluid));
        int color = ex.getTintColor(fluid);
        this.renderLargeFluidCuboid(info.pose(), ver, info.light(), xd, xBounds, zd, zBounds, curY, curY + h, tex, color);
        curY += h;
    }
}

