/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileIrisCreation;
import sweetmagic.util.RenderUtil;

public class RenderIrisCreation<T extends TileIrisCreation>
extends RenderAbstractTile<T> {
    public RenderIrisCreation(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileIrisCreation)tile).isCraft) {
            return;
        }
        PoseStack pose = info.pose();
        int ticlTime = ((TileIrisCreation)tile).clientTime;
        int craftTime = ((TileIrisCreation)tile).craftTime;
        ItemStack stack = ((TileIrisCreation)tile).craftList.get(0);
        float size = 0.3f;
        pose.m_85836_();
        pose.m_85837_(0.5, 0.75, 0.5);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        pose.m_85845_(Vector3f.f_122227_.m_122240_((float)ticlTime * 5.0f));
        pose.m_85841_(size, size, size);
        info.itemRenderNo(stack);
        pose.m_85849_();
        float rotY = (float)ticlTime / 90.0f;
        int maxSize = ((TileIrisCreation)tile).craftList.size();
        float progress = 1.0f - (float)craftTime / (float)((TileIrisCreation)tile).maxCraftTime;
        for (int i = 1; i < maxSize; ++i) {
            stack = ((TileIrisCreation)tile).craftList.get(i);
            pose.m_85836_();
            pose.m_85837_(0.5, 0.75, 0.5);
            pose.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            Objects.requireNonNull(this);
            pose.m_85845_(Vector3f.f_122227_.m_122240_(rotY * 57.295776f + (float)(i * (360 / (maxSize - 1))) + (float)ticlTime * 6.75f));
            pose.m_85841_(size, size, size);
            pose.m_85837_((double)(0.85f * progress), 0.0, 0.0);
            info.itemRenderNo(stack);
            pose.m_85849_();
        }
    }
}

