/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFFisher;
import sweetmagic.util.RenderUtil;

public class RenderMFFisher<T extends TileMFFisher>
extends RenderAbstractTile<T> {
    private static final ItemStack SQUARE = new ItemStack((ItemLike)BlockInit.magic_square);
    private static final Block SQUARE_BLOCK = BlockInit.magic_square_s;

    public RenderMFFisher(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        int data = ((TileMFFisher)tile).getData();
        this.renderItem(tile, parTick, info, data);
        if (tile.isMFEmpty()) {
            return;
        }
        this.renderSquare(tile, parTick, info, data);
    }

    public void renderItem(T tile, float parTick, RenderUtil.RenderInfo info, int data) {
        double addY = 0.0;
        float scale = 0.5f;
        double shake = 0.1;
        if (data == 3 || data == 4) {
            addY += 0.5;
            scale = 0.375f;
            shake = 0.0;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5 + addY, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * shake, 0.0);
        pose.m_85841_(scale, scale, scale);
        float f = ((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        ItemStack stack = ItemStack.f_41583_;
        switch (data) {
            case 0: {
                stack = TileMFFisher.FISHING_ROD;
                break;
            }
            case 1: {
                stack = TileMFFisher.MACHETE;
                break;
            }
            case 2: {
                stack = TileMFFisher.MILK_PACK;
                break;
            }
            case 3: {
                stack = TileMFFisher.AETHER_CRYSTAL;
                break;
            }
            case 4: {
                stack = TileMFFisher.DIVINE_CRYSTAL;
                break;
            }
            case 5: {
                stack = TileMFFisher.ALT_PICK;
                break;
            }
            case 6: {
                stack = TileMFFisher.EGG_BAG;
            }
        }
        info.itemRender(stack);
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info, int data) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        boolean isFurnace = data == 3 || data == 4;
        double addY = isFurnace ? -0.6 : 0.0;
        pose.m_85837_(0.5, 1.65 + addY, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.02, 0.0);
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        float f = ((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        if (isFurnace) {
            pose.m_85837_(-0.25, -0.25, -0.25);
            pose.m_85841_(0.5f, 0.5f, 0.5f);
            RenderUtil.RenderColor color = data == 3 ? RenderUtil.RenderColor.create(76.0f, 165.0f, 255.0f, info) : RenderUtil.RenderColor.create(102.0f, 206.0f, 255.0f, info);
            RenderUtil.renderBlock(info, color, SQUARE_BLOCK);
        } else {
            info.itemRender(SQUARE);
        }
        pose.m_85849_();
    }

    @Override
    public int m_142163_() {
        return 32;
    }
}

