/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFMinerAdvanced;
import sweetmagic.util.RenderUtil;

public class RenderMFMinerAdvanced<T extends TileMFMinerAdvanced>
extends RenderAbstractTile<T> {
    private static final ItemStack STACK = new ItemStack((ItemLike)ItemInit.fluorite_pick);
    private static final Block SQUARE = BlockInit.magic_square_l;

    public RenderMFMinerAdvanced(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        this.renderItem(tile, parTick, info);
        if (tile.isMFEmpty()) {
            return;
        }
        this.renderSquare(tile, parTick, info);
    }

    public void renderItem(T tile, float parTick, RenderUtil.RenderInfo info) {
        float scale = 0.5f;
        double shake = 0.1;
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * shake, 0.0);
        pose.m_85841_(scale, scale, scale);
        float f = ((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        info.itemRender(STACK);
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.65, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.02, 0.0);
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        float f = ((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85837_(-0.25, -0.25, -0.25);
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderBlock(info, RenderUtil.RenderColor.create(102.0f, 206.0f, 255.0f, info), SQUARE);
        pose.m_85849_();
    }
}

