/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileMFSpawner;
import sweetmagic.util.RenderUtil;

public class RenderMFSpawner<T extends TileMFSpawner>
extends RenderAbstractTile<T> {
    private int tickTime = 0;

    public RenderMFSpawner(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (((TileMFSpawner)tile).isPeace || ((TileMFSpawner)tile).getMobType() == -1) {
            return;
        }
        LivingEntity entity = ((TileMFSpawner)tile).getRenderEntity();
        if (this.tickTime++ % 3 == 0) {
            ++entity.f_19797_;
            this.tickTime = 1;
        }
        float f = 0.675f;
        float f1 = Math.max(entity.m_20205_(), entity.m_20206_());
        if ((double)f1 > 1.0) {
            f /= f1;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.0, 0.5);
        pose.m_85837_(0.0, 0.4, 0.0);
        long gameTime = entity.f_19797_;
        float f2 = ((float)gameTime + parTick) * 0.25f;
        Objects.requireNonNull(this);
        float angle = f2 * 57.295776f;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        pose.m_85837_(0.0, -0.2, 0.0);
        pose.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        pose.m_85841_(f, f, f);
        this.eRender.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, parTick, pose, info.buf(), info.light());
        pose.m_85849_();
        if (!((TileMFSpawner)tile).viewRange) {
            return;
        }
        pose.m_85836_();
        BlockPos targetPos = ((TileMFSpawner)tile).getTargetPos();
        BlockPos pos = tile.m_58899_();
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();
        VertexConsumer ver = buf.m_6299_(RenderType.m_110504_());
        int difX = pos.m_123341_() - targetPos.m_123341_();
        int difZ = pos.m_123343_() - targetPos.m_123343_();
        int range = ((TileMFSpawner)tile).spawnRange;
        double base = 0.001;
        double sX = (double)(-range - difX) + base;
        double sY = base;
        double sZ = (double)(-range - difZ) + base;
        double eX = (double)(range + 1 - difX) - base;
        double eY = 3.0 - base;
        double eZ = (double)(range + 1 - difZ) - base;
        LevelRenderer.m_109621_((PoseStack)pose, (VertexConsumer)ver, (double)sX, (double)sY, (double)sZ, (double)eX, (double)eY, (double)eZ, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
        pose.m_85849_();
    }
}

