/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFTable;
import sweetmagic.util.RenderUtil;

public class RenderMFTable<T extends TileMFTable>
extends RenderAbstractTile<T> {
    public RenderMFTable(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        int count = ((TileMFTable)tile).getInvSize();
        if (count <= 1) {
            ItemStack stack = ((TileMFTable)tile).getInputItem(0);
            if (stack.m_41619_()) {
                return;
            }
            this.renderStack(tile, parTick, info, gameTime, stack);
        } else {
            float rotY = ((float)gameTime + parTick) * 0.05f;
            PoseStack pose = info.pose();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = ((TileMFTable)tile).getInputItem(i);
                if (stack.m_41619_()) continue;
                pose.m_85836_();
                pose.m_85837_(0.5, (double)1.3f, 0.5);
                Objects.requireNonNull(this);
                pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY * 57.295776f + (float)(i * (360 / count))));
                pose.m_85841_(0.5f, 0.5f, 0.5f);
                pose.m_85837_(-1.0, 0.0, 0.0);
                info.itemRenderNo(stack);
                pose.m_85849_();
            }
            ItemStack stack = ((TileMFTable)tile).getFuelItem();
            if (!stack.m_41619_()) {
                this.renderStack(tile, parTick, info, gameTime, stack);
            }
        }
    }

    public void renderStack(T tile, float parTick, RenderUtil.RenderInfo info, int gameTime, ItemStack stack) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.4, 0.5);
        pose.m_85837_(0.0, Math.sin((double)((float)gameTime + parTick) * 0.1) * 0.1, 0.0);
        float rotY = ((float)gameTime + parTick) * 0.05f;
        Objects.requireNonNull(this);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY * 57.295776f));
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        info.itemRenderNo(stack);
        pose.m_85849_();
    }
}

