/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.RenderTypeInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileMFTank;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.RenderUtil;

public class RenderMFTank<T extends TileMFTank>
extends RenderAbstractTile<T> {
    private static final ResourceLocation SRC = SweetMagicCore.getSRC("block/mf_water_still");

    public RenderMFTank(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (tile.isMFEmpty()) {
            return;
        }
        int xd = 0;
        int zd = 0;
        if (xd < 0 || zd < 0) {
            return;
        }
        float[] xBounds = this.getBlockBounds(xd);
        float[] zBounds = this.getBlockBounds(zd);
        VertexConsumer ver = info.buf().m_6299_(RenderTypeInit.SMELTERY_FLUID);
        float curY = 0.005f;
        float scale = Math.min(1.0f, (float)((TileSMMagic)tile).getMF() / (float)((TileMFTank)tile).getMaxMF());
        float h = 0.99f * scale;
        TextureAtlasSprite tex = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(SRC);
        this.renderLargeFluidCuboid(info.pose(), ver, info.light(), xd, xBounds, zd, zBounds, curY, curY + h, tex, -1);
        curY += h;
    }
}

