/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaTable;
import sweetmagic.util.RenderUtil;

public class RenderMagiaTable<T extends TileMagiaTable>
extends RenderAbstractTile<T> {
    private static final ResourceLocation MAGIC_BOOK = SweetMagicCore.getSRC("textures/entity/magia_book.png");
    private final BookModel bookModel;
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)MAGIC_BOOK);

    public RenderMagiaTable(BlockEntityRendererProvider.Context con) {
        super(con);
        this.bookModel = new BookModel(con.m_173582_(ModelLayers.f_171271_));
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        this.renderBook(tile, parTick, info);
        this.renderItem(tile, parTick, info);
    }

    public void renderBook(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.0, 0.5);
        float f = (float)((TileMagiaTable)tile).time + parTick;
        pose.m_85837_(0.0, (double)(0.1f + Mth.m_14031_((float)(f * 0.1f)) * 0.01f), 0.0);
        float rot = 1.5825f;
        switch (((TileAbstractSM)tile).getFace()) {
            case SOUTH: {
                rot = 4.7f;
                break;
            }
            case EAST: {
                rot = 0.0f;
                break;
            }
            case WEST: {
                rot = 3.15f;
            }
        }
        pose.m_85845_(Vector3f.f_122225_.m_122270_(rot));
        pose.m_85845_(Vector3f.f_122227_.m_122240_(80.0f));
        float f3 = Mth.m_14179_((float)parTick, (float)((TileMagiaTable)tile).oFlip, (float)((TileMagiaTable)tile).flip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)parTick, (float)((TileMagiaTable)tile).oOpen, (float)((TileMagiaTable)tile).open);
        this.bookModel.m_102292_(f, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer vert = info.buf().m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        this.bookModel.m_102316_(pose, vert, info.light(), info.overlay(), 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    public void renderItem(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileMagiaTable)tile).isCraft || ((TileMagiaTable)tile).copyMagic.m_41619_()) {
            return;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.75, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin((double)((float)gameTime + parTick) * 0.15) * 0.075, 0.0);
        float rotY = ((float)gameTime + parTick) * 0.0375f;
        Objects.requireNonNull(this);
        pose.m_85845_(Vector3f.f_122225_.m_122240_(rotY * 57.295776f));
        pose.m_85841_(0.5f, 0.5f, 0.5f);
        info.itemRenderNo(((TileMagiaTable)tile).copyMagic);
        pose.m_85849_();
    }
}

