/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.sm.TileAbstractMagicianLectern;

public class RenderMagicianLectern
implements BlockEntityRenderer<TileAbstractMagicianLectern> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = SweetMagicCore.getSRC("textures/entity/magician_lectern_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)END_CRYSTAL_LOCATION);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart glass;

    public RenderMagicianLectern(BlockEntityRendererProvider.Context con) {
        ModelPart model = con.m_173582_(ModelLayers.f_171145_);
        this.glass = model.m_171324_("glass");
    }

    public void render(TileAbstractMagicianLectern tile, float parTick, PoseStack pose, MultiBufferSource buf, int light, int overlayLight) {
        if (tile.summonType.is(TileAbstractMagicianLectern.SummonType.END)) {
            return;
        }
        float f = 0.0f;
        int gameTime = tile.getClientTime();
        float f1 = ((float)gameTime + parTick) * 3.0f;
        float size = 1.0f + Math.min(1.0f, (float)tile.tileTime * 0.00625f);
        float addY = Math.min(0.5f, (float)tile.tileTime * 0.003125f);
        VertexConsumer vert = buf.m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        pose.m_85836_();
        pose.m_85841_(size, size, size);
        pose.m_85837_(0.5 - (double)(addY / 2.0f), -0.3 + (double)addY, 0.5 - (double)(addY / 2.0f));
        int overray = OverlayTexture.f_118083_;
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85837_(0.0, (double)(1.5f + f / 2.0f), 0.0);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        this.glass.m_104301_(pose, vert, light, overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        this.glass.m_104301_(pose, vert, light, overray);
        pose.m_85841_(0.875f, 0.875f, 0.875f);
        pose.m_85845_(new Quaternion(new Vector3f(SIN_45, 0.0f, SIN_45), 60.0f, true));
        pose.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        pose.m_85849_();
    }
}

